import request from '@/utils/request'

// 查询市级行政区列表
export function listRegion(query) {
  return request({
    url: '/area/city/list',
    method: 'get',
    params: query
  })
}

// 查询市级行政区详细
export function getRegion(fId) {
  return request({
    url: '/area/city/' + fId,
    method: 'get'
  })
}

// 新增市级行政区
export function addRegion(data) {
  return request({
    url: '/area/city',
    method: 'post',
    data: data
  })
}

// 修改市级行政区
export function updateRegion(data) {
  return request({
    url: '/area/city',
    method: 'put',
    data: data
  })
}

// 删除市级行政区
export function delRegion(fId) {
  return request({
    url: '/area/city/' + fId,
    method: 'delete'
  })
}

// 导出市级行政区
export function exportRegion(query) {
  return request({
    url: '/area/city/export',
    method: 'get',
    params: query
  })
}
