package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainPersonMapper;
import com.zehong.system.domain.TTrainPerson;
import com.zehong.system.service.ITTrainPersonService;

/**
 * 燃气培训人员Service业务层处理
 * 
 * @author zehong
 * @date 2023-04-22
 */
@Service
public class TTrainPersonServiceImpl implements ITTrainPersonService 
{
    @Autowired
    private TTrainPersonMapper tTrainPersonMapper;

    /**
     * 查询燃气培训人员
     * 
     * @param id 燃气培训人员ID
     * @return 燃气培训人员
     */
    @Override
    public TTrainPerson selectTTrainPersonById(Long id)
    {
        return tTrainPersonMapper.selectTTrainPersonById(id);
    }

    /**
     * 查询燃气培训人员列表
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 燃气培训人员
     */
    @Override
    public List<TTrainPerson> selectTTrainPersonList(TTrainPerson tTrainPerson)
    {
        return tTrainPersonMapper.selectTTrainPersonList(tTrainPerson);
    }

    /**
     * 新增燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    @Override
    public int insertTTrainPerson(TTrainPerson tTrainPerson)
    {
        tTrainPerson.setCreateTime(DateUtils.getNowDate());
        return tTrainPersonMapper.insertTTrainPerson(tTrainPerson);
    }

    /**
     * 修改燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    @Override
    public int updateTTrainPerson(TTrainPerson tTrainPerson)
    {
        tTrainPerson.setUpdateTime(DateUtils.getNowDate());
        return tTrainPersonMapper.updateTTrainPerson(tTrainPerson);
    }

    /**
     * 批量删除燃气培训人员
     * 
     * @param ids 需要删除的燃气培训人员ID
     * @return 结果
     */
    @Override
    public int deleteTTrainPersonByIds(Long[] ids)
    {
        return tTrainPersonMapper.deleteTTrainPersonByIds(ids);
    }

    /**
     * 删除燃气培训人员信息
     * 
     * @param id 燃气培训人员ID
     * @return 结果
     */
    @Override
    public int deleteTTrainPersonById(Long id)
    {
        return tTrainPersonMapper.deleteTTrainPersonById(id);
    }
}
