package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.mapper.TTaskRecordMapper;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 任务记录Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-06
 */
@Service
public class TTaskRecordServiceImpl implements ITTaskRecordService
{
    @Autowired
    private TTaskRecordMapper tTaskRecordMapper;

    /**
     * 查询任务记录
     * 
     * @param taskRecordId 任务记录ID
     * @return 任务记录
     */
    @Override
    public TTaskRecord selectTTaskRecordById(Long taskRecordId)
    {
        return tTaskRecordMapper.selectTTaskRecordById(taskRecordId);
    }

    /**
     * 查询任务记录列表
     * 
     * @param tTaskRecord 任务记录
     * @return 任务记录
     */
    @Override
    public List<TTaskRecord> selectTTaskRecordList(TTaskRecord tTaskRecord)
    {
        return tTaskRecordMapper.selectTTaskRecordList(tTaskRecord);
    }

    /**
     * 新增任务记录
     * 
     * @param tTaskRecord 任务记录
     * @return 结果
     */
    @Override
    public int insertTTaskRecord(TTaskRecord tTaskRecord)
    {
        tTaskRecord.setCreateTime(DateUtils.getNowDate());
        return tTaskRecordMapper.insertTTaskRecord(tTaskRecord);
    }

    /**
     * 修改任务记录
     * 
     * @param tTaskRecord 任务记录
     * @return 结果
     */
    @Override
    public int updateTTaskRecord(TTaskRecord tTaskRecord)
    {
        return tTaskRecordMapper.updateTTaskRecord(tTaskRecord);
    }

    /**
     * 批量删除任务记录
     * 
     * @param taskRecordIds 需要删除的任务记录ID
     * @return 结果
     */
    @Override
    public int deleteTTaskRecordByIds(Long[] taskRecordIds)
    {
        return tTaskRecordMapper.deleteTTaskRecordByIds(taskRecordIds);
    }

    /**
     * 删除任务记录信息
     * 
     * @param taskRecordId 任务记录ID
     * @return 结果
     */
    @Override
    public int deleteTTaskRecordById(Long taskRecordId)
    {
        return tTaskRecordMapper.deleteTTaskRecordById(taskRecordId);
    }
}
