package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupBalStopSupOprPressLogMapper;
import com.zehong.system.domain.TSupBalStopSupOprPressLog;
import com.zehong.system.service.ITSupBalStopSupOprPressLogService;

/**
 * 供需平衡-停气监管-停气进度操作历史记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-16
 */
@Service
public class TSupBalStopSupOprPressLogServiceImpl implements ITSupBalStopSupOprPressLogService 
{
    @Autowired
    private TSupBalStopSupOprPressLogMapper tSupBalStopSupOprPressLogMapper;

    /**
     * 查询供需平衡-停气监管-停气进度操作历史记录
     * 
     * @param fOprPressLogId 供需平衡-停气监管-停气进度操作历史记录ID
     * @return 供需平衡-停气监管-停气进度操作历史记录
     */
    @Override
    public TSupBalStopSupOprPressLog selectTSupBalStopSupOprPressLogById(Long fOprPressLogId)
    {
        return tSupBalStopSupOprPressLogMapper.selectTSupBalStopSupOprPressLogById(fOprPressLogId);
    }

    /**
     * 查询供需平衡-停气监管-停气进度操作历史记录列表
     * 
     * @param tSupBalStopSupOprPressLog 供需平衡-停气监管-停气进度操作历史记录
     * @return 供需平衡-停气监管-停气进度操作历史记录
     */
    @Override
    public List<TSupBalStopSupOprPressLog> selectTSupBalStopSupOprPressLogList(TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        return tSupBalStopSupOprPressLogMapper.selectTSupBalStopSupOprPressLogList(tSupBalStopSupOprPressLog);
    }

    /**
     * 新增供需平衡-停气监管-停气进度操作历史记录
     * 
     * @param tSupBalStopSupOprPressLog 供需平衡-停气监管-停气进度操作历史记录
     * @return 结果
     */
    @Override
    public int insertTSupBalStopSupOprPressLog(TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        return tSupBalStopSupOprPressLogMapper.insertTSupBalStopSupOprPressLog(tSupBalStopSupOprPressLog);
    }

    /**
     * 修改供需平衡-停气监管-停气进度操作历史记录
     * 
     * @param tSupBalStopSupOprPressLog 供需平衡-停气监管-停气进度操作历史记录
     * @return 结果
     */
    @Override
    public int updateTSupBalStopSupOprPressLog(TSupBalStopSupOprPressLog tSupBalStopSupOprPressLog)
    {
        return tSupBalStopSupOprPressLogMapper.updateTSupBalStopSupOprPressLog(tSupBalStopSupOprPressLog);
    }

    /**
     * 批量删除供需平衡-停气监管-停气进度操作历史记录
     * 
     * @param fOprPressLogIds 需要删除的供需平衡-停气监管-停气进度操作历史记录ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalStopSupOprPressLogByIds(Long[] fOprPressLogIds)
    {
        return tSupBalStopSupOprPressLogMapper.deleteTSupBalStopSupOprPressLogByIds(fOprPressLogIds);
    }

    /**
     * 删除供需平衡-停气监管-停气进度操作历史记录信息
     * 
     * @param fOprPressLogId 供需平衡-停气监管-停气进度操作历史记录ID
     * @return 结果
     */
    @Override
    public int deleteTSupBalStopSupOprPressLogById(Long fOprPressLogId)
    {
        return tSupBalStopSupOprPressLogMapper.deleteTSupBalStopSupOprPressLogById(fOprPressLogId);
    }
}
