package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TProjectInfoMapper;
import com.zehong.system.domain.TProjectInfo;
import com.zehong.system.service.ITProjectInfoService;

/**
 * 工程项目信息Service业务层处理
 *
 * @author zehong
 * @date 2022-03-16
 */
@Service
public class TProjectInfoServiceImpl implements ITProjectInfoService
{
    @Autowired
    private TProjectInfoMapper tProjectInfoMapper;

    /**
     * 查询工程项目信息
     *
     * @param projectId 工程项目信息ID
     * @return 工程项目信息
     */
    @Override
    public TProjectInfo selectTProjectInfoById(Long projectId)
    {
        return tProjectInfoMapper.selectTProjectInfoById(projectId);
    }

    /**
     * 查询工程项目信息列表
     *
     * @param tProjectInfo 工程项目信息
     * @return 工程项目信息
     */
    @Override
    public List<TProjectInfo> selectTProjectInfoList(TProjectInfo tProjectInfo)
    {
        return tProjectInfoMapper.selectTProjectInfoList(tProjectInfo);
    }

    /**
     * 新增工程项目信息
     *
     * @param tProjectInfo 工程项目信息
     * @return 结果
     */
    @Override
    public int insertTProjectInfo(TProjectInfo tProjectInfo)
    {
        tProjectInfo.setCreateTime(DateUtils.getNowDate());
        return tProjectInfoMapper.insertTProjectInfo(tProjectInfo);
    }

    /**
     * 修改工程项目信息
     *
     * @param tProjectInfo 工程项目信息
     * @return 结果
     */
    @Override
    public int updateTProjectInfo(TProjectInfo tProjectInfo)
    {
        tProjectInfo.setUpdateTime(DateUtils.getNowDate());
        return tProjectInfoMapper.updateTProjectInfo(tProjectInfo);
    }

    /**
     * 批量删除工程项目信息
     *
     * @param projectIds 需要删除的工程项目信息ID
     * @return 结果
     */
    @Override
    public int deleteTProjectInfoByIds(Long[] projectIds)
    {
        return tProjectInfoMapper.deleteTProjectInfoByIds(projectIds);
    }

    /**
     * 删除工程项目信息信息
     *
     * @param projectId 工程项目信息ID
     * @return 结果
     */
    @Override
    public int deleteTProjectInfoById(Long projectId)
    {
        return tProjectInfoMapper.deleteTProjectInfoById(projectId);
    }

    /**
     * 查询是否已经有重复的年份数据
     * @param projectYear
     * @return
     */
    @Override
    public List<TProjectInfo> selectSameYear(Date projectYear,String beyondEnterpriseId) {
        List<TProjectInfo> tProjectInfos = tProjectInfoMapper.selectSameYear(projectYear,beyondEnterpriseId);
        return tProjectInfos;
    }

    /**
     * 重复年份删除方法
     * @param isSameYear
     */
    @Override
    public void deleteisSameYear(Date isSameYear,String beyondEnterpriseId) {
        tProjectInfoMapper.deleteisSameYear(isSameYear,beyondEnterpriseId);
    }

    /**
     * 查询修改文件之前的路径
     * @param projectId
     * @return
     */
    @Override
    public TProjectInfo selectNearbyAddress(Long projectId) {
        TProjectInfo tProjectInfo = tProjectInfoMapper.selectNearbyAddress(projectId);
        return tProjectInfo;
    }

    /**
     * 查询企业名称
     * @param deptId
     * @return
     */
    @Override
    public String selectEnterpriseName(String deptId) {
        String enterpriseName = tProjectInfoMapper.selectEnterpriseName(deptId);
        return enterpriseName;
    }
    @Override
    public Map<String,Object> selectNum(){
        return tProjectInfoMapper.selectNum();
    }

}
