package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TProAppInforBrowseMapper;
import com.zehong.system.domain.TProAppInforBrowse;
import com.zehong.system.service.ITProAppInforBrowseService;

/**
 * 行业专家库-专家库浏览Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-08
 */
@Service
public class TProAppInforBrowseServiceImpl implements ITProAppInforBrowseService 
{
    @Autowired
    private TProAppInforBrowseMapper tProAppInforBrowseMapper;

    /**
     * 查询行业专家库-专家库浏览
     * 
     * @param fProAppInforId 行业专家库-专家库浏览ID
     * @return 行业专家库-专家库浏览
     */
    @Override
    public TProAppInforBrowse selectTProAppInforBrowseById(Long fProAppInforId)
    {
        return tProAppInforBrowseMapper.selectTProAppInforBrowseById(fProAppInforId);
    }

    /**
     * 查询行业专家库-专家库浏览列表
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 行业专家库-专家库浏览
     */
    @Override
    public List<TProAppInforBrowse> selectTProAppInforBrowseList(TProAppInforBrowse tProAppInforBrowse)
    {
        return tProAppInforBrowseMapper.selectTProAppInforBrowseList(tProAppInforBrowse);
    }

    /**
     * 新增行业专家库-专家库浏览
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 结果
     */
    @Override
    public int insertTProAppInforBrowse(TProAppInforBrowse tProAppInforBrowse)
    {
        return tProAppInforBrowseMapper.insertTProAppInforBrowse(tProAppInforBrowse);
    }

    /**
     * 修改行业专家库-专家库浏览
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 结果
     */
    @Override
    public int updateTProAppInforBrowse(TProAppInforBrowse tProAppInforBrowse)
    {
        return tProAppInforBrowseMapper.updateTProAppInforBrowse(tProAppInforBrowse);
    }

    /**
     * 批量删除行业专家库-专家库浏览
     * 
     * @param fProAppInforIds 需要删除的行业专家库-专家库浏览ID
     * @return 结果
     */
    @Override
    public int deleteTProAppInforBrowseByIds(Long[] fProAppInforIds)
    {
        return tProAppInforBrowseMapper.deleteTProAppInforBrowseByIds(fProAppInforIds);
    }

    /**
     * 删除行业专家库-专家库浏览信息
     * 
     * @param fProAppInforId 行业专家库-专家库浏览ID
     * @return 结果
     */
    @Override
    public int deleteTProAppInforBrowseById(Long fProAppInforId)
    {
        return tProAppInforBrowseMapper.deleteTProAppInforBrowseById(fProAppInforId);
    }
}
