package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TComplainDealTransfer;
import com.zehong.system.mapper.TComplainDealTransferMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPlanInfoMapper;
import com.zehong.system.domain.TPlanInfo;
import com.zehong.system.service.ITPlanInfoService;

/**
 * 应急预案Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-11
 */
@Service
public class TPlanInfoServiceImpl implements ITPlanInfoService 
{
    @Autowired
    private TPlanInfoMapper tPlanInfoMapper;

    @Autowired
    private TComplainDealTransferMapper tComplainDealTransferMapper;

    /**
     * 查询应急预案
     * 
     * @param planId 应急预案ID
     * @return 应急预案
     */
    @Override
    public TPlanInfo selectTPlanInfoById(Long planId)
    {
        return tPlanInfoMapper.selectTPlanInfoById(planId);
    }

    /**
     * 查询应急预案列表
     * 
     * @param tPlanInfo 应急预案
     * @return 应急预案
     */
    @Override
    public List<TPlanInfo> selectTPlanInfoList(TPlanInfo tPlanInfo)
    {
        return tPlanInfoMapper.selectTPlanInfoList(tPlanInfo);
    }

    /**
     * 新增应急预案
     * 
     * @param tPlanInfo 应急预案
     * @return 结果
     */
    @Override
    public int insertTPlanInfo(TPlanInfo tPlanInfo)
    {
        tPlanInfo.setCreateTime(DateUtils.getNowDate());
        return tPlanInfoMapper.insertTPlanInfo(tPlanInfo);
    }

    /**
     * 修改应急预案
     * 
     * @param tPlanInfo 应急预案
     * @return 结果
     */
    @Override
    public int updateTPlanInfo(TPlanInfo tPlanInfo)
    {
        tPlanInfo.setUpdateTime(DateUtils.getNowDate());
        return tPlanInfoMapper.updateTPlanInfo(tPlanInfo);
    }

    /**
     * 批量删除应急预案
     * 
     * @param planIds 需要删除的应急预案ID
     * @return 结果
     */
    @Override
    public int deleteTPlanInfoByIds(Long[] planIds)
    {
        return tPlanInfoMapper.deleteTPlanInfoByIds(planIds);
    }

    /**
     * 删除应急预案信息
     * 
     * @param planId 应急预案ID
     * @return 结果
     */
    @Override
    public int deleteTPlanInfoById(Long planId)
    {
        return tPlanInfoMapper.deleteTPlanInfoById(planId);
    }


    @Override
    public List<Map<String,Object>> selectEnterprise(){
        return tPlanInfoMapper.selectEnterprise();
    }

    @Override
    public List<Map<String, Object>> transferEnterpriseList(Long complainDealId) {
        List<TComplainDealTransfer> tComplainDealTransfers =
                tComplainDealTransferMapper.queryComplainDealTransferListByComplainDealId(complainDealId);
        if (tComplainDealTransfers != null && tComplainDealTransfers.size() > 0) {
            List<String> collect = tComplainDealTransfers.stream().map(TComplainDealTransfer::getEnterpriseId).collect(Collectors.toList());
            return tPlanInfoMapper.transferEnterpriseList(collect);
        } else {
            return new ArrayList<>();
        }
    }
}
