package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPatrolCheckInMapper;
import com.zehong.system.domain.TPatrolCheckIn;
import com.zehong.system.service.ITPatrolCheckInService;

/**
 * 巡检签到Service业务层处理
 * 
 * @author zehong
 * @date 2023-03-10
 */
@Service
public class TPatrolCheckInServiceImpl implements ITPatrolCheckInService 
{
    @Autowired
    private TPatrolCheckInMapper tPatrolCheckInMapper;

    /**
     * 查询巡检签到
     * 
     * @param checkInId 巡检签到ID
     * @return 巡检签到
     */
    @Override
    public TPatrolCheckIn selectTPatrolCheckInById(Long checkInId)
    {
        return tPatrolCheckInMapper.selectTPatrolCheckInById(checkInId);
    }

    /**
     * 查询巡检签到列表
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 巡检签到
     */
    @Override
    public List<TPatrolCheckIn> selectTPatrolCheckInList(TPatrolCheckIn tPatrolCheckIn)
    {
        return tPatrolCheckInMapper.selectTPatrolCheckInList(tPatrolCheckIn);
    }

    /**
     * 新增巡检签到
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 结果
     */
    @Override
    public int insertTPatrolCheckIn(TPatrolCheckIn tPatrolCheckIn)
    {
        return tPatrolCheckInMapper.insertTPatrolCheckIn(tPatrolCheckIn);
    }

    /**
     * 修改巡检签到
     * 
     * @param tPatrolCheckIn 巡检签到
     * @return 结果
     */
    @Override
    public int updateTPatrolCheckIn(TPatrolCheckIn tPatrolCheckIn)
    {
        return tPatrolCheckInMapper.updateTPatrolCheckIn(tPatrolCheckIn);
    }

    /**
     * 批量删除巡检签到
     * 
     * @param checkInIds 需要删除的巡检签到ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolCheckInByIds(Long[] checkInIds)
    {
        return tPatrolCheckInMapper.deleteTPatrolCheckInByIds(checkInIds);
    }

    /**
     * 删除巡检签到信息
     * 
     * @param checkInId 巡检签到ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolCheckInById(Long checkInId)
    {
        return tPatrolCheckInMapper.deleteTPatrolCheckInById(checkInId);
    }
}
