package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TMessageDetailInfo;
import com.zehong.system.domain.TMessageInfo;
import com.zehong.system.mapper.TMessageDetailInfoMapper;
import com.zehong.system.mapper.TMessageInfoMapper;
import com.zehong.system.service.ITMessageInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 消息Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-14
 */
@Service
public class TMessageInfoServiceImpl implements ITMessageInfoService 
{
    @Autowired
    private TMessageInfoMapper tMessageInfoMapper;

    @Autowired
    private TMessageDetailInfoMapper tMessageDetailInfoMapper;

    /**
     * 查询消息
     * 
     * @param messageId 消息ID
     * @return 消息
     */
    @Override
    public TMessageInfo selectTMessageInfoById(Long messageId)
    {
        return tMessageInfoMapper.selectTMessageInfoById(messageId);
    }

    /**
     * 查询消息列表
     * 
     * @param tMessageInfo 消息
     * @return 消息
     */
    @Override
    public List<TMessageInfo> selectTMessageInfoList(TMessageInfo tMessageInfo)
    {
        return tMessageInfoMapper.selectTMessageInfoList(tMessageInfo);
    }
    @Override
    public List<TMessageInfo> selectTMessageInfoListapp(TMessageInfo tMessageInfo)
    {
        return tMessageInfoMapper.selectTMessageInfoListapp(tMessageInfo);
    }


    /**
     * 新增消息
     * 
     * @param tMessageInfo 消息
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTMessageInfo(TMessageInfo tMessageInfo)
    {
        tMessageInfo.setCreateTime(DateUtils.getNowDate());
        tMessageInfo.setCreateBy(SecurityUtils.getUsername());
        int i = tMessageInfoMapper.insertTMessageInfo(tMessageInfo);

        if(tMessageInfo.getPersonIds()!=null&&tMessageInfo.getPersonIds().length>0){
            for (String personId:tMessageInfo.getPersonIds()){
                TMessageDetailInfo info = new TMessageDetailInfo();
                info.setMessageId(tMessageInfo.getMessageId());
                info.setCreateTime(new Date());
                info.setPersonId(Long.parseLong(personId));
                tMessageDetailInfoMapper.insertTMessageDetailInfo(info);
            }
        }else {
            for(TMessageDetailInfo tMessageDetailInfo : tMessageInfo.getMessageDetailInfoList()){
                tMessageDetailInfo.setMessageId(tMessageInfo.getMessageId());
                tMessageDetailInfo.setCreateTime(new Date());
                tMessageDetailInfoMapper.insertTMessageDetailInfo(tMessageDetailInfo);
            }
        }
        return i;
    }

    /**
     * 修改消息
     * 
     * @param tMessageInfo 消息
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateTMessageInfo(TMessageInfo tMessageInfo)
    {
        tMessageInfo.setUpdateTime(DateUtils.getNowDate());
        int i = tMessageInfoMapper.updateTMessageInfo(tMessageInfo);
        if(tMessageInfo.getMessageDetailInfoList()!=null){
            tMessageDetailInfoMapper.deleteMessageDetailByMessageId(tMessageInfo.getMessageId());
            for(TMessageDetailInfo tMessageDetailInfo : tMessageInfo.getMessageDetailInfoList()){
                tMessageDetailInfo.setMessageId(tMessageInfo.getMessageId());
                tMessageDetailInfo.setCreateTime(new Date());
                tMessageDetailInfoMapper.insertTMessageDetailInfo(tMessageDetailInfo);
            }
        }

        return i;
    }

    /**
     * 批量删除消息
     * 
     * @param messageIds 需要删除的消息ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTMessageInfoByIds(Long[] messageIds)
    {
        for(Long messageId :messageIds){
            tMessageDetailInfoMapper.deleteMessageDetailByMessageId(messageId);
        }
        return tMessageInfoMapper.deleteTMessageInfoByIds(messageIds);
    }

    /**
     * 删除消息信息
     * 
     * @param messageId 消息ID
     * @return 结果
     */
    @Override
    public int deleteTMessageInfoById(Long messageId)
    {
        return tMessageInfoMapper.deleteTMessageInfoById(messageId);
    }
}
