package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMessageDetailInfoMapper;
import com.zehong.system.domain.TMessageDetailInfo;
import com.zehong.system.service.ITMessageDetailInfoService;

/**
 * 消息详情Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-14
 */
@Service
public class TMessageDetailInfoServiceImpl implements ITMessageDetailInfoService 
{
    @Autowired
    private TMessageDetailInfoMapper tMessageDetailInfoMapper;

    /**
     * 查询消息详情
     * 
     * @param messageDetailId 消息详情ID
     * @return 消息详情
     */
    @Override
    public TMessageDetailInfo selectTMessageDetailInfoById(Long messageDetailId)
    {
        return tMessageDetailInfoMapper.selectTMessageDetailInfoById(messageDetailId);
    }

    /**
     * 查询消息详情列表
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 消息详情
     */
    @Override
    public List<TMessageDetailInfo> selectTMessageDetailInfoList(TMessageDetailInfo tMessageDetailInfo)
    {
        return tMessageDetailInfoMapper.selectTMessageDetailInfoList(tMessageDetailInfo);
    }

    /**
     * 新增消息详情
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 结果
     */
    @Override
    public int insertTMessageDetailInfo(TMessageDetailInfo tMessageDetailInfo)
    {
        tMessageDetailInfo.setCreateTime(DateUtils.getNowDate());
        return tMessageDetailInfoMapper.insertTMessageDetailInfo(tMessageDetailInfo);
    }

    /**
     * 修改消息详情
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 结果
     */
    @Override
    public int updateTMessageDetailInfo(TMessageDetailInfo tMessageDetailInfo)
    {
        tMessageDetailInfo.setUpdateTime(DateUtils.getNowDate());
        return tMessageDetailInfoMapper.updateTMessageDetailInfo(tMessageDetailInfo);
    }

    /**
     * 批量删除消息详情
     * 
     * @param messageDetailIds 需要删除的消息详情ID
     * @return 结果
     */
    @Override
    public int deleteTMessageDetailInfoByIds(Long[] messageDetailIds)
    {
        return tMessageDetailInfoMapper.deleteTMessageDetailInfoByIds(messageDetailIds);
    }

    /**
     * 删除消息详情信息
     * 
     * @param messageDetailId 消息详情ID
     * @return 结果
     */
    @Override
    public int deleteTMessageDetailInfoById(Long messageDetailId)
    {
        return tMessageDetailInfoMapper.deleteTMessageDetailInfoById(messageDetailId);
    }
}
