package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TLinePatrolMapper;
import com.zehong.system.domain.TLinePatrol;
import com.zehong.system.service.ITLinePatrolService;

/**
 * 巡线Service业务层处理
 *
 * @author zehong
 * @date 2026-02-02
 */
@Service
public class TLinePatrolServiceImpl implements ITLinePatrolService
{
    @Autowired
    private TLinePatrolMapper tLinePatrolMapper;

    /**
     * 查询巡线
     *
     * @param id 巡线ID
     * @return 巡线
     */
    @Override
    public TLinePatrol selectTLinePatrolById(Long id)
    {
        return tLinePatrolMapper.selectTLinePatrolById(id);
    }

    /**
     * 查询巡线列表
     *
     * @param tLinePatrol 巡线
     * @return 巡线
     */
    @Override
    public List<TLinePatrol> selectTLinePatrolList(TLinePatrol tLinePatrol)
    {
        return tLinePatrolMapper.selectTLinePatrolList(tLinePatrol);
    }

    /**
     * 新增巡线
     *
     * @param tLinePatrol 巡线
     * @return 结果
     */
    @Override
    public int insertTLinePatrol(TLinePatrol tLinePatrol)
    {
        tLinePatrol.setCreateTime(DateUtils.getNowDate());
        return tLinePatrolMapper.insertTLinePatrol(tLinePatrol);
    }

    /**
     * 修改巡线
     *
     * @param tLinePatrol 巡线
     * @return 结果
     */
    @Override
    public int updateTLinePatrol(TLinePatrol tLinePatrol)
    {
        return tLinePatrolMapper.updateTLinePatrol(tLinePatrol);
    }

    /**
     * 批量删除巡线
     *
     * @param ids 需要删除的巡线ID
     * @return 结果
     */
    @Override
    public int deleteTLinePatrolByIds(Long[] ids)
    {
        return tLinePatrolMapper.deleteTLinePatrolByIds(ids);
    }

    /**
     * 删除巡线信息
     *
     * @param id 巡线ID
     * @return 结果
     */
    @Override
    public int deleteTLinePatrolById(Long id)
    {
        return tLinePatrolMapper.deleteTLinePatrolById(id);
    }

    @Override
    public int insertBatch(List<TLinePatrol> tLinePatrol) {
        return tLinePatrolMapper.insertBatch(tLinePatrol);
    }
}