package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectReportMapper;
import com.zehong.system.domain.TInspectReport;
import com.zehong.system.service.ITInspectReportService;

/**
 * 入户安检结果Service业务层处理
 * 
 * @author zehong
 * @date 2026-02-02
 */
@Service
public class TInspectReportServiceImpl implements ITInspectReportService 
{
    @Autowired
    private TInspectReportMapper tInspectReportMapper;

    /**
     * 查询入户安检结果
     * 
     * @param reportId 入户安检结果ID
     * @return 入户安检结果
     */
    @Override
    public TInspectReport selectTInspectReportById(Long reportId)
    {
        return tInspectReportMapper.selectTInspectReportById(reportId);
    }

    /**
     * 查询入户安检结果列表
     * 
     * @param tInspectReport 入户安检结果
     * @return 入户安检结果
     */
    @Override
    public List<TInspectReport> selectTInspectReportList(TInspectReport tInspectReport)
    {
        return tInspectReportMapper.selectTInspectReportList(tInspectReport);
    }

    /**
     * 安检汇总列表
     * @param tInspectReport
     * @return
     */
    @Override
    public List<TInspectReport> selectTInspectSummaryList(TInspectReport tInspectReport)
    {
        return tInspectReportMapper.selectTInspectSummaryList(tInspectReport);
    }
    /**
     * 新增入户安检结果
     * 
     * @param tInspectReport 入户安检结果
     * @return 结果
     */
    @Override
    public int insertTInspectReport(TInspectReport tInspectReport)
    {
        tInspectReport.setCreateTime(DateUtils.getNowDate());
        return tInspectReportMapper.insertTInspectReport(tInspectReport);
    }

    /**
     * 修改入户安检结果
     * 
     * @param tInspectReport 入户安检结果
     * @return 结果
     */
    @Override
    public int updateTInspectReport(TInspectReport tInspectReport)
    {
        return tInspectReportMapper.updateTInspectReport(tInspectReport);
    }

    /**
     * 批量删除入户安检结果
     * 
     * @param reportIds 需要删除的入户安检结果ID
     * @return 结果
     */
    @Override
    public int deleteTInspectReportByIds(Long[] reportIds)
    {
        return tInspectReportMapper.deleteTInspectReportByIds(reportIds);
    }

    /**
     * 删除入户安检结果信息
     * 
     * @param reportId 入户安检结果ID
     * @return 结果
     */
    @Override
    public int deleteTInspectReportById(Long reportId)
    {
        return tInspectReportMapper.deleteTInspectReportById(reportId);
    }
}
