package com.zehong.system.service.impl;

import java.sql.SQLIntegrityConstraintViolationException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsTaskInforMapper;
import com.zehong.system.domain.TInsTaskInfor;
import com.zehong.system.service.ITInsTaskInforService;

/**
 * 监督检查-检查任务Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-16
 */
@Service
public class TInsTaskInforServiceImpl implements ITInsTaskInforService 
{
    @Autowired
    private TInsTaskInforMapper tInsTaskInforMapper;

    /**
     * 查询监督检查-检查任务
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 监督检查-检查任务
     */
    @Override
    public TInsTaskInfor selectTInsTaskInforById(Long fInsTaskInforId)
    {
        return tInsTaskInforMapper.selectTInsTaskInforById(fInsTaskInforId);
    }

    /**
     * 查询监督检查-检查任务列表
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 监督检查-检查任务
     */
    @Override
    public List<TInsTaskInfor> selectTInsTaskInforList(TInsTaskInfor tInsTaskInfor)
    {
        return tInsTaskInforMapper.selectTInsTaskInforList(tInsTaskInfor);
    }

    /**
     * 新增监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    @Override
    public int insertTInsTaskInfor(TInsTaskInfor tInsTaskInfor)
    {
        try {
            tInsTaskInfor.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            tInsTaskInfor.setfCreateBy(SecurityUtils.getUsername());
            return tInsTaskInforMapper.insertTInsTaskInfor(tInsTaskInfor);
        }catch (Exception  e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_unique_code")){
                    throw new CustomException("任务唯一编码不唯一");
                }
            }
            return 0;
        }

    }

    /**
     * 修改监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    @Override
    public int updateTInsTaskInfor(TInsTaskInfor tInsTaskInfor)
    {
        try{
            tInsTaskInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            tInsTaskInfor.setfModifyBy(SecurityUtils.getUsername());
            return tInsTaskInforMapper.updateTInsTaskInfor(tInsTaskInfor);
        }catch (Exception e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_unique_code")){
                    throw new CustomException("任务唯一编码不唯一");
                }
            }
            return 0;
        }
    }

    /**
     * 批量删除监督检查-检查任务
     * 
     * @param fInsTaskInforIds 需要删除的监督检查-检查任务ID
     * @return 结果
     */
    @Override
    public int deleteTInsTaskInforByIds(Long[] fInsTaskInforIds)
    {
        return tInsTaskInforMapper.deleteTInsTaskInforByIds(fInsTaskInforIds);
    }

    /**
     * 删除监督检查-检查任务信息
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 结果
     */
    @Override
    public int deleteTInsTaskInforById(Long fInsTaskInforId)
    {
        return tInsTaskInforMapper.deleteTInsTaskInforById(fInsTaskInforId);
    }
}
