package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsSurListInforMapper;
import com.zehong.system.domain.TInsSurListInfor;
import com.zehong.system.service.ITInsSurListInforService;

/**
 * 监督检查-调查项Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-18
 */
@Service
public class TInsSurListInforServiceImpl implements ITInsSurListInforService 
{
    @Autowired
    private TInsSurListInforMapper tInsSurListInforMapper;

    /**
     * 查询监督检查-调查项
     * 
     * @param fInsSurListInforId 监督检查-调查项ID
     * @return 监督检查-调查项
     */
    @Override
    public TInsSurListInfor selectTInsSurListInforById(Long fInsSurListInforId)
    {
        return tInsSurListInforMapper.selectTInsSurListInforById(fInsSurListInforId);
    }

    /**
     * 查询监督检查-调查项列表
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 监督检查-调查项
     */
    @Override
    public List<TInsSurListInfor> selectTInsSurListInforList(TInsSurListInfor tInsSurListInfor)
    {
        return tInsSurListInforMapper.selectTInsSurListInforList(tInsSurListInfor);
    }

    /**
     * 新增监督检查-调查项
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 结果
     */
    @Override
    public int insertTInsSurListInfor(TInsSurListInfor tInsSurListInfor)
    {
        tInsSurListInfor.setfLastUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tInsSurListInforMapper.insertTInsSurListInfor(tInsSurListInfor);
    }

    /**
     * 修改监督检查-调查项
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 结果
     */
    @Override
    public int updateTInsSurListInfor(TInsSurListInfor tInsSurListInfor)
    {
        tInsSurListInfor.setfLastUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tInsSurListInforMapper.updateTInsSurListInfor(tInsSurListInfor);
    }

    /**
     * 批量删除监督检查-调查项
     * 
     * @param fInsSurListInforIds 需要删除的监督检查-调查项ID
     * @return 结果
     */
    @Override
    public int deleteTInsSurListInforByIds(Long[] fInsSurListInforIds)
    {
        return tInsSurListInforMapper.deleteTInsSurListInforByIds(fInsSurListInforIds);
    }

    /**
     * 删除监督检查-调查项信息
     * 
     * @param fInsSurListInforId 监督检查-调查项ID
     * @return 结果
     */
    @Override
    public int deleteTInsSurListInforById(Long fInsSurListInforId)
    {
        return tInsSurListInforMapper.deleteTInsSurListInforById(fInsSurListInforId);
    }
}
