package com.zehong.system.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDoubleBookMapper;
import com.zehong.system.domain.TDoubleBook;
import com.zehong.system.service.ITDoubleBookService;

/**
 * 双代台账Service业务层处理
 * 
 * @author zehong
 * @date 2024-04-21
 */
@Service
public class TDoubleBookServiceImpl implements ITDoubleBookService 
{
    @Autowired
    private TDoubleBookMapper tDoubleBookMapper;

    /**
     * 查询双代台账
     * 
     * @param bookId 双代台账ID
     * @return 双代台账
     */
    @Override
    public TDoubleBook selectTDoubleBookById(Long bookId)
    {
        return tDoubleBookMapper.selectTDoubleBookById(bookId);
    }

    /**
     * 查询双代台账列表
     * 
     * @param tDoubleBook 双代台账
     * @return 双代台账
     */
    @Override
    public List<TDoubleBook> selectTDoubleBookList(TDoubleBook tDoubleBook)
    {
        // 20240726 调整 政府和企业都可以录，企业看自己，政府看所有
        if (isEnterprise() && tDoubleBook != null) {
            tDoubleBook.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        return tDoubleBookMapper.selectTDoubleBookList(tDoubleBook);
    }

    /**
     * 导出
     * @param tDoubleBook 双代台账
     * @return r
     */
    @Override
    public List<TDoubleBook> exportTDoubleBookList(TDoubleBook tDoubleBook) {
        // 20240726 调整 政府和企业都可以录，企业看自己，政府看所有
        if (isEnterprise() && tDoubleBook != null) {
            tDoubleBook.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        return tDoubleBookMapper.exportTDoubleBookList(tDoubleBook);
    }

    /**
     * 新增双代台账
     * 
     * @param tDoubleBook 双代台账
     * @return 结果
     */
    @Override
    public int insertTDoubleBook(TDoubleBook tDoubleBook)
    {
        tDoubleBook.setCreateTime(DateUtils.getNowDate());
        return tDoubleBookMapper.insertTDoubleBook(tDoubleBook);
    }

    /**
     * 修改双代台账
     * 
     * @param tDoubleBook 双代台账
     * @return 结果
     */
    @Override
    public int updateTDoubleBook(TDoubleBook tDoubleBook)
    {
        return tDoubleBookMapper.updateTDoubleBook(tDoubleBook);
    }

    /**
     * 批量删除双代台账
     * 
     * @param bookIds 需要删除的双代台账ID
     * @return 结果
     */
    @Override
    public int deleteTDoubleBookByIds(Long[] bookIds)
    {
        return tDoubleBookMapper.deleteTDoubleBookByIds(bookIds);
    }

    /**
     * 删除双代台账信息
     * 
     * @param bookId 双代台账ID
     * @return 结果
     */
    @Override
    public int deleteTDoubleBookById(Long bookId)
    {
        return tDoubleBookMapper.deleteTDoubleBookById(bookId);
    }


    /**
     * 判断是否为企业
     * @return
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }
}
