package com.zehong.system.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceReportDataMapper;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.service.ITDeviceReportDataService;

import javax.annotation.Resource;

/**
 * 设备监控Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-16
 */
@Service
public class TDeviceReportDataServiceImpl implements ITDeviceReportDataService 
{
    @Resource
    private TDeviceReportDataMapper tDeviceReportDataMapper;

    /**
     * 查询设备监控
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 设备监控
     */
    @Override
    public TDeviceReportData selectTDeviceReportDataById(Long deviceReportDataId)
    {
        return tDeviceReportDataMapper.selectTDeviceReportDataById(deviceReportDataId);
    }

    /**
     * 查询设备监控列表
     * 
     * @param tDeviceReportData 设备监控
     * @return 设备监控
     */
    @Override
    public List<TDeviceReportData> selectTDeviceReportDataList(TDeviceReportData tDeviceReportData)
    {
        // 20240725 调整 分 企业 和 政府 角色录入
        if(isEnterprise()) {
            tDeviceReportData.setBeyondEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }

        return tDeviceReportDataMapper.selectTDeviceReportDataList(tDeviceReportData);
    }

    /**
     * 新增设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    @Override
    public int insertTDeviceReportData(TDeviceReportData tDeviceReportData)
    {
        tDeviceReportData.setCreateTime(DateUtils.getNowDate());
        return tDeviceReportDataMapper.insertTDeviceReportData(tDeviceReportData);
    }

    /**
     * 修改设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    @Override
    public int updateTDeviceReportData(TDeviceReportData tDeviceReportData)
    {
        tDeviceReportData.setUpdateTime(DateUtils.getNowDate());
        return tDeviceReportDataMapper.updateTDeviceReportData(tDeviceReportData);
    }

    /**
     * 批量删除设备监控
     * 
     * @param deviceReportDataIds 需要删除的设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceReportDataByIds(Long[] deviceReportDataIds)
    {
        return tDeviceReportDataMapper.deleteTDeviceReportDataByIds(deviceReportDataIds);
    }

    /**
     * 删除设备监控信息
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceReportDataById(Long deviceReportDataId)
    {
        return tDeviceReportDataMapper.deleteTDeviceReportDataById(deviceReportDataId);
    }

    /**
     * 判断是否为企业
     * @return
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }

}
