package com.zehong.system.service.impl;

import com.github.pagehelper.PageInfo;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TDetectorInfo;
import com.zehong.system.mapper.TDetectorInfoMapper;
import com.zehong.system.service.ITDetectorInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 探测器Service业务层处理
 * 
 * @author zehong
 * @date 2021-11-02
 */
@Service
public class TDetectorInfoServiceImpl implements ITDetectorInfoService
{
    @Autowired
    private TDetectorInfoMapper tDetectorInfoMapper;

    /**
     * 查询探测器
     * 
     * @param detectorId 探测器ID
     * @return 探测器
     */
    @Override
    public TDetectorInfo selectTDetectorInfoById(Long detectorId)
    {
        return tDetectorInfoMapper.selectTDetectorInfoById(detectorId);
    }

    /**
     * 查询探测器
     *
     * @param detectorCode 探测器编号
     * @return 探测器
     */
    public TDetectorInfo selectTDetectorInfoByCode(String detectorCode) {
        return tDetectorInfoMapper.selectTDetectorInfoByCode(detectorCode);
    }

    /**
     * 查询探测器列表
     * 
     * @param tDetectorInfo 探测器
     * @return 探测器
     */
    @Override
    public List<TDetectorInfo> selectTDetectorInfoList(TDetectorInfo tDetectorInfo)
    {
        List<TDetectorInfo> list = tDetectorInfoMapper.selectTDetectorInfoList(tDetectorInfo);
        for(TDetectorInfo detector : list){
            if("0".equals(detector.getDetectorStatus())){
                detector.setDetectorStatus("在线");
            } else if("1".equals(detector.getDetectorStatus())) {
                detector.setDetectorStatus("离线");
            } else {
                detector.setDetectorStatus("报警");
            }
        }

        return list;
    }

    /**
     * 查询探测器分页列表
     *
     * @param tDetectorInfo 探测器
     * @return 探测器
     */
    @Override
    public PageInfo<TDetectorInfo> selectTDetectorInfoPage(TDetectorInfo tDetectorInfo)
    {
        List<TDetectorInfo> list = tDetectorInfoMapper.selectTDetectorInfoList(tDetectorInfo);
        for(TDetectorInfo detector : list){
            if("0".equals(detector.getDetectorStatus())){
                detector.setDetectorStatus("正常");
            } else if("1".equals(detector.getDetectorStatus())) {
                detector.setDetectorStatus("离线");
            } else {
                detector.setDetectorStatus("报警");
            }
        }
        return new PageInfo(list);
    }

    /**
     * 新增探测器
     * 
     * @param tDetectorInfo 探测器
     * @return 结果
     */
    @Override
    public int insertTDetectorInfo(TDetectorInfo tDetectorInfo)
    {
        return tDetectorInfoMapper.insertTDetectorInfo(tDetectorInfo);
    }

    @Override
    public int insertBatch(List<TDetectorInfo> detectorList) {
        // TODO Auto-generated method stub
        return tDetectorInfoMapper.insertBatch(detectorList);
    }

    @Override
    public int updateBatch(List<TDetectorInfo> detectorList) {
        // TODO Auto-generated method stub
        return tDetectorInfoMapper.updateBatch(detectorList);
    }

    /**
     * 修改探测器
     * 
     * @param tDetectorInfo 探测器
     * @return 结果
     */
    @Override
    public int updateTDetectorInfo(TDetectorInfo tDetectorInfo)
    {
        return tDetectorInfoMapper.updateTDetectorInfo(tDetectorInfo);
    }

    /**
     * 批量删除探测器
     * 
     * @param detectorIds 需要删除的探测器ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorInfoByIds(Long[] detectorIds)
    {
        return tDetectorInfoMapper.deleteTDetectorInfoByIds(detectorIds);
    }

    /**
     * 删除探测器信息
     * 
     * @param detectorId 探测器ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorInfoById(Long detectorId)
    {
        return tDetectorInfoMapper.deleteTDetectorInfoById(detectorId);
    }
    /**
     * 用户安全监控设备 数量
     * @return
     */
    @Override
    public Map<String,Object> selectDetectorNum(String enterpriseId){
        return tDetectorInfoMapper.selectDetectorNum(enterpriseId.split(","));
    }

    /**
     * 获取探测器监控数据
     * @param tDetectorInfo
     * @return
     */
    @Override
    public List<TDetectorInfo> selectDetectorMointor(TDetectorInfo tDetectorInfo){

        // 20240725调整 如果是企业，则只查企业的数据
        if (isEnterprise()) {
            tDetectorInfo.setEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }

        return tDetectorInfoMapper.selectDetectorMointor(tDetectorInfo);
    }

    /**
     * 判断是否为企业
     * @return
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }
}
