package com.zehong.system.service.impl;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.domain.TComplainDealTransfer;
import com.zehong.system.mapper.TComplainDealMapper;
import com.zehong.system.mapper.TComplainDealTransferMapper;
import com.zehong.system.service.ITComplainDealTransferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 燃气投诉处置-转办记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-06
 */
@Service
public class TComplainDealTransferServiceImpl implements ITComplainDealTransferService 
{
    @Autowired
    private TComplainDealTransferMapper tComplainDealTransferMapper;

    @Autowired
    private TComplainDealMapper tComplainDealMapper;

    /**
     * 查询燃气投诉处置-转办记录
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 燃气投诉处置-转办记录
     */
    @Override
    public TComplainDealTransfer selectTComplainDealTransferById(Long complainDealTransferId)
    {
        return tComplainDealTransferMapper.selectTComplainDealTransferById(complainDealTransferId);
    }

    /**
     * 查询燃气投诉处置-转办记录列表
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 燃气投诉处置-转办记录
     */
    @Override
    public List<TComplainDealTransfer> selectTComplainDealTransferList(TComplainDealTransfer tComplainDealTransfer)
    {
        return tComplainDealTransferMapper.selectTComplainDealTransferList(tComplainDealTransfer);
    }


    /**
     * 根据 投诉处置id查询 转办记录列表
     * @param complainDealId id
     * @return list
     */
    @Override
    public List<Map<String,Object>> queryComplainDealTransferListByComplainDealId(Long complainDealId) {
        List<TComplainDealTransfer> tComplainDealTransfers = tComplainDealTransferMapper.queryComplainDealTransferListByComplainDealId(complainDealId);

        List<Map<String,Object>> list = new ArrayList<>();
        if (tComplainDealTransfers != null && tComplainDealTransfers.size() > 0) {
            Map<String,Object> item ;
            for (TComplainDealTransfer tComplainDealTransfer : tComplainDealTransfers) {
                item = new HashMap<>();
                String sj = DateUtils.dateTime(tComplainDealTransfer.getCreateTime());
                item.put("sj",sj);

                List<Map<String,String>> dictList = new ArrayList<>();
                Map<String,String> dictListItem = new HashMap<>();
                dictListItem.put("indexCode","enterpriseName");
                dictListItem.put("label","企业名称");
                dictList.add(dictListItem);
                dictListItem = new HashMap<>();
                dictListItem.put("indexCode","assignMan");
                dictListItem.put("label","指派人");
                dictList.add(dictListItem);
                dictListItem = new HashMap<>();
                dictListItem.put("indexCode","reasonConcent");
                dictListItem.put("label","退回原因");
                dictList.add(dictListItem);
                item.put("dictList",dictList);

                List<Map<String,String>> rows = new ArrayList<>();
                Map<String,String> rowsItem = new HashMap<>();
                rowsItem.put("enterpriseName", tComplainDealTransfer.getEnterpriseName());
                rowsItem.put("assignMan", tComplainDealTransfer.getComplainAssignMan());
                rowsItem.put("reasonConcent", tComplainDealTransfer.getReasonConcent());
                rows.add(rowsItem);
                item.put("rows",rows);
                list.add(item);
            }
        }
        return list;
    }

    /**
     * 新增燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor= Exception.class)
    public AjaxResult insertTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer)
    {

        if (tComplainDealTransfer.getComplainDealId() == null) {
            return AjaxResult.error("参数丢失！！！");
        }

        //先修改数据的状态 改成4  退回状态，并清理 指派单位，指派人
        TComplainDeal tComplainDeal = new TComplainDeal();
        tComplainDeal.setComplainDealId(tComplainDealTransfer.getComplainDealId());
        tComplainDeal.setComplainStatus("4");
        tComplainDeal.setComplainAssignEnterproseId(null);
        tComplainDeal.setComplainAssignEnterproseName(null);
        tComplainDeal.setComplainAssignMan(null);
        tComplainDeal.setComplainAssignManId(null);
        tComplainDealMapper.clearTComplainDeal(tComplainDeal);

        LoginUser loginUser = SecurityUtils.getLoginUser();

        //用户的部门id就是 企业id
        String deptId = loginUser.getUser().getDeptId();
        tComplainDealTransfer.setEnterpriseId(deptId);

        tComplainDealTransfer.setCreateBy(loginUser.getUsername());
        tComplainDealTransfer.setCreateTime(DateUtils.getNowDate());
        return AjaxResult.success(tComplainDealTransferMapper.insertTComplainDealTransfer(tComplainDealTransfer));
    }

    /**
     * 修改燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    @Override
    public int updateTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer)
    {
        return tComplainDealTransferMapper.updateTComplainDealTransfer(tComplainDealTransfer);
    }

    /**
     * 批量删除燃气投诉处置-转办记录
     * 
     * @param complainDealTransferIds 需要删除的燃气投诉处置-转办记录ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealTransferByIds(Long[] complainDealTransferIds)
    {
        return tComplainDealTransferMapper.deleteTComplainDealTransferByIds(complainDealTransferIds);
    }

    /**
     * 删除燃气投诉处置-转办记录信息
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealTransferById(Long complainDealTransferId)
    {
        return tComplainDealTransferMapper.deleteTComplainDealTransferById(complainDealTransferId);
    }
}
