package com.zehong.system.service.impl;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.domain.TComplainDealOverSuper;
import com.zehong.system.mapper.TComplainDealMapper;
import com.zehong.system.mapper.TComplainDealOverSuperMapper;
import com.zehong.system.service.ITComplainDealOverSuperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 燃气投诉处置-超时督办Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-13
 */
@Service
public class TComplainDealOverSuperServiceImpl implements ITComplainDealOverSuperService 
{
    @Autowired
    private TComplainDealOverSuperMapper tComplainDealOverSuperMapper;

    @Autowired
    private TComplainDealMapper tComplainDealMapper;

    /**
     * 查询燃气投诉处置-超时督办
     * 
     * @param complainDealOverSuperId 燃气投诉处置-超时督办ID
     * @return 燃气投诉处置-超时督办
     */
    @Override
    public TComplainDealOverSuper selectTComplainDealOverSuperById(Long complainDealOverSuperId)
    {
        return tComplainDealOverSuperMapper.selectTComplainDealOverSuperById(complainDealOverSuperId);
    }

    /**
     * 查询燃气投诉处置-超时督办列表
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 燃气投诉处置-超时督办
     */
    @Override
    public List<TComplainDealOverSuper> selectTComplainDealOverSuperList(TComplainDealOverSuper tComplainDealOverSuper)
    {
        return tComplainDealOverSuperMapper.selectTComplainDealOverSuperList(tComplainDealOverSuper);
    }

    /**
     * 新增燃气投诉处置-超时督办
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor= Exception.class)
    public int insertTComplainDealOverSuper(TComplainDealOverSuper tComplainDealOverSuper)
    {
        tComplainDealOverSuper.setOvertimeSupervision("0");
        tComplainDealOverSuper.setCreateTime(DateUtils.getNowDate());
        tComplainDealOverSuperMapper.insertTComplainDealOverSuper(tComplainDealOverSuper);

        // 只根据id 修改 状态值
        TComplainDeal tComplainDeal = new TComplainDeal();
        tComplainDeal.setComplainDealId(tComplainDealOverSuper.getComplainDealId());
        tComplainDeal.setOvertimeSupervision("0");
        return tComplainDealMapper.updateTComplainDeal(tComplainDeal);
    }

    /**
     * 修改燃气投诉处置-超时督办
     * 
     * @param tComplainDealOverSuper 燃气投诉处置-超时督办
     * @return 结果
     */
    @Override
    public int updateTComplainDealOverSuper(TComplainDealOverSuper tComplainDealOverSuper)
    {

        SysUser user = SecurityUtils.getLoginUser().getUser();
        String deptId = user.getDeptId();

        if (!"-2".equals(deptId)) {
            // 只根据id 修改 状态值
            TComplainDeal tComplainDeal = new TComplainDeal();
            tComplainDeal.setComplainDealId(tComplainDealOverSuper.getComplainDealId());
            if("0".equals(tComplainDealOverSuper.getOvertimeSupervision())) {
                tComplainDealOverSuper.setOvertimeSupervision("1");
            }
            tComplainDeal.setOvertimeSupervision(tComplainDealOverSuper.getOvertimeSupervision());
            tComplainDealMapper.updateTComplainDeal(tComplainDeal);
        }
        return tComplainDealOverSuperMapper.updateTComplainDealOverSuper(tComplainDealOverSuper);
    }

    /**
     * 批量删除燃气投诉处置-超时督办
     * 
     * @param complainDealOverSuperIds 需要删除的燃气投诉处置-超时督办ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealOverSuperByIds(Long[] complainDealOverSuperIds)
    {
        return tComplainDealOverSuperMapper.deleteTComplainDealOverSuperByIds(complainDealOverSuperIds);
    }

    /**
     * 删除燃气投诉处置-超时督办信息
     * 
     * @param complainDealOverSuperId 燃气投诉处置-超时督办ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealOverSuperById(Long complainDealOverSuperId)
    {
        return tComplainDealOverSuperMapper.deleteTComplainDealOverSuperById(complainDealOverSuperId);
    }

    /**
     * 查询燃气投诉处置-超时督办列表-根据处置id 和 状态
     * @param tComplainDealOverSuper
     * @return
     */
    @Override
    public TComplainDealOverSuper getOverSuperByComplainDealIdAndStatus(TComplainDealOverSuper tComplainDealOverSuper) {
        return tComplainDealOverSuperMapper.getOverSuperByComplainDealIdAndStatus(tComplainDealOverSuper);
    }

    /**
     * 超时督办确认反馈
     * @param tComplainDealOverSuper s
     */
    @Override
    @Transactional(rollbackFor= Exception.class)
    public int overtimeSupervisionFeedbackConfirmation(TComplainDealOverSuper tComplainDealOverSuper) {

        // 只根据id 修改 状态值
        TComplainDeal tComplainDeal = new TComplainDeal();
        tComplainDeal.setComplainDealId(tComplainDealOverSuper.getComplainDealId());
        tComplainDeal.setOvertimeSupervision(tComplainDealOverSuper.getOvertimeSupervision());
        tComplainDealMapper.updateTComplainDeal(tComplainDeal);

        return tComplainDealOverSuperMapper.updateTComplainDealOverSuper(tComplainDealOverSuper);
    }
}
