package com.zehong.system.service.impl;
import com.zehong.system.domain.*;
import com.zehong.system.mapper.PipeInterfaceMapper;
import com.zehong.system.service.IPipeInterfaceService;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * 管道信息数据实现层
 */
@Service
public class PipeInterfaceServiceImpl implements IPipeInterfaceService {

    @Autowired
    PipeInterfaceMapper pipeInterfaceMapper;

    /**
     * 查询管道数据列表
     * @return
     */
    @Override
    public List<PipeDate> selectPipeData(String enterId) {
        List<PipeDate> pipeDates = pipeInterfaceMapper.selectPipeData(enterId);
        return pipeDates;
    }

    /**
     * 查询管道数据列表 名称不为空
     * @return
     */
    @Override
    public List<PipeDate> getPipeForSelect(String enterId) {
        List<PipeDate> pipeDates = pipeInterfaceMapper.getPipeForSelect(enterId);
        return pipeDates;
    }

    @Override
    public PipeDate getPipeBypipeId(String pipeId) {
        return pipeInterfaceMapper.getPipeBypipeId(pipeId);
    }

    /**
     * 获取分组数据
     * @return
     */
    @Override
    public List<PipeDate> selectGroupPipeData() {
        List<PipeDate> pipeDates = pipeInterfaceMapper.selectGroupPipeData();
        return pipeDates;
    }

    /**
     * 调压箱数据查询方法
     * @return
     */
    @Override
    public List<DeviceData> selectDeviceData(String enterId) {
        List<DeviceData> deviceData = pipeInterfaceMapper.selectDeviceData(enterId);
        return deviceData;
    }

    /**
     * 查询下级设备数据
     * @param deviceId
     * @return
     */
    @Override
    public List<PressureFlow> selectPressureFlow(String deviceId) {
        List<PressureFlow> pressureFlows = pipeInterfaceMapper.selectPressureFlow(deviceId);
        return pressureFlows;
    }

    /**
     * 场站信息查询方法
     * @return
     */
    @Override
    public List<TSiteStationInfoData> selectTSiteStationInfoData(String enterId) {
        List<TSiteStationInfoData> tSiteStationInfoData = pipeInterfaceMapper.selectTSiteStationInfoData(enterId);
        return tSiteStationInfoData;
    }

    /**
     * 查询场站下级数据
     * @param siteStationId
     * @return
     */
    @Override
    public List<PressureFlow> selecttSiteStationInfoDataList(String siteStationId) {
        List<PressureFlow> pressureFlows = pipeInterfaceMapper.selecttSiteStationInfoDataList(siteStationId);
        return pressureFlows;
    }

    /**
     * 监控信息查询
     * @return
     */
    @Override
    public List<TvideoManagerData> selectTvideoManagerData() {
        List<TvideoManagerData> tvideoManagerData = pipeInterfaceMapper.selectTvideoManagerData();
        return tvideoManagerData;
    }

    /**
     * 燃气用户信息查询接口
     * @return
     */
    @Override
    public List<TdetectorUserData> selectTdetectorUser() {
        List<TdetectorUserData> tdetectorUserData = pipeInterfaceMapper.selectTdetectorUser();
        return tdetectorUserData;
    }

    /**
     * 查询企业名称id方法
     * @return
     */
    @Override
    public List<TenterpriseInfoData> selectTenterpriseInfoData() {
        List<TenterpriseInfoData> tenterpriseInfoData = pipeInterfaceMapper.selectTenterpriseInfoData();
        return tenterpriseInfoData;
    }

    /**
     * 查询阀门井数据
     * @return
     */
    @Override
    public List<DeviceData> selectvalveData(String enterId) {
        List<DeviceData> pipeDates = pipeInterfaceMapper.selectvalveData(enterId);
        return pipeDates;
    }

    /**
     * 查询下级在线设备数量
     * @param pressureList
     * @return
     */
    @Override
    public int  selectOnlineQuantity(List<PressureFlow> pressureList, int isOnLine) {
        int i = pipeInterfaceMapper.selectOnlineQuantity(pressureList,isOnLine);
        return i;
    }

    /**
     * 查询历史报警数量
     * @param pressureList
     * @return
     */
    @Override
    public int selectHistoricalAlarm(List<PressureFlow> pressureList) {
        int i = pipeInterfaceMapper.selectHistoricalAlarm(pressureList);
        return i;
    }

    /**
     * 查询已处理报警
     * @param pressureList
     * @return
     */
    @Override
    public int selectProcessAlarm(List<PressureFlow> pressureList) {
        int i = pipeInterfaceMapper.selectProcessAlarm(pressureList);
        return i;
    }

    /**
     * 查询报警中
     * @param pressureList
     * @return
     */
    @Override
    public int selectInAlarm(List<PressureFlow> pressureList) {
        int i = pipeInterfaceMapper.selectInAlarm(pressureList);
        return i;
    }

    /**
     * 查询 场站/设备 列表信息方法
     * @param devId
     * @param relationDeviceType
     * @return
     */
    @Override
    public List<TAssociatedEquipment> selectSensingDevice(String devId, String relationDeviceType) {
        List<TAssociatedEquipment> tAssociatedEquipments = pipeInterfaceMapper.selectSensingDevice(devId, relationDeviceType);
        return tAssociatedEquipments;
    }

    /**
     * 查询上级设备是否有下级设备
     * @param deviceId
     * @return
     */
    @Override
    public int selectValveWellIsNUll(String deviceId,int type) {
        return pipeInterfaceMapper.selectValveWellIsNUll(deviceId,type);
    }

    /**
     * 查询下级全部数据方法
     * @param type
     * @return
     */
    @Override
    public List<PressureFlow> selectPressureFlows(String type) {
        List<PressureFlow> flows = pipeInterfaceMapper.selectPressureFlows(type);
        return flows;
    }
}
