package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.system.domain.*;
import com.zehong.system.domain.vo.*;
import com.zehong.system.mapper.*;
import com.zehong.system.service.GovernmentSupervisionInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author geng
 * 政府监管平台信息
 */
@Service
public class GovernmentSupervisionInfoServiceImpl implements GovernmentSupervisionInfoService {

    private static final Logger log = LoggerFactory.getLogger(GovernmentSupervisionInfoServiceImpl.class);

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    @Resource
    private TProAppInforBrowseMapper tProAppInforBrowseMapper;

    @Resource
    private FProBehInforBrowseMapper fProBehInforBrowseMapper;

    @Resource
    private TInsTaskInforMapper tInsTaskInforMapper;

    @Resource
    private TInsScopeInforMapper tInsScopeInforMapper;

    @Resource
    private TInsInsListInforMapper tInsInsListInforMapper;

    @Resource
    private TInsSurListInforMapper insSurListInforMapper;

    @Resource
    private TInsSpotHazardRefMapper tInsSpotHazardRefMapper;

    @Resource
    private TInsStaInforMapper tInsStaInforMapper;

    @Resource
    private TCityLevelRegionMapper tCityLevelRegionMapper;

    @Resource
    private TCountyLevelRegionMapper tCountyLevelRegionMapper;

    @Resource
    private TTownLevelRegionMapper tTownLevelRegionMapper;

    @Resource
    private TVillageLevelRegionMapper tVillageLevelRegionMapper;

    /**
     * 获取市级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getCity(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("region/city/information","READ",map);
        log.info("获取市级行政区结果=========" + json.toString());
        //结果入库
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TCityLevelRegion> tCityLevelRegionList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TCityLevelRegionVo tCityLevelRegionVo = JSONObject.toJavaObject(data.getJSONObject(i), TCityLevelRegionVo.class);
                TCityLevelRegion cityLevelRegion = new TCityLevelRegion();
                GovernmentDataCopyUtil.copyToLocalData(tCityLevelRegionVo,cityLevelRegion);
                tCityLevelRegionList.add(cityLevelRegion);
            }
            tCityLevelRegionMapper.batchInsertTCityLevelRegion(tCityLevelRegionList);
        }
        return json;
    }

    /**
     * 获取县级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getCounty(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("region/county/information","READ",map);
        log.info("获取县级行政区结果=========" + json.toString());
        //结果入库
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TCountyLevelRegion> tCountyLevelRegionList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TCountyLevelRegionVo tCountyLevelRegionVo = JSONObject.toJavaObject(data.getJSONObject(i), TCountyLevelRegionVo.class);
                TCountyLevelRegion countyLevelRegion = new TCountyLevelRegion();
                GovernmentDataCopyUtil.copyToLocalData(tCountyLevelRegionVo,countyLevelRegion);
                tCountyLevelRegionList.add(countyLevelRegion);
            }
            tCountyLevelRegionMapper.batchInsertTCountyLevelRegion(tCountyLevelRegionList);
        }
        return json;
    }

    /**
     * 获取乡级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getTown(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("region/town/information","READ",map);
        log.info("获取乡级行政区结果=========" + json.toString());
        //结果入库
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List< TTownLevelRegion> townLevelRegionList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TTownLevelRegionVo tTownLevelRegionVo = JSONObject.toJavaObject(data.getJSONObject(i), TTownLevelRegionVo.class);
                TTownLevelRegion townLevelRegion = new TTownLevelRegion();
                GovernmentDataCopyUtil.copyToLocalData(tTownLevelRegionVo,townLevelRegion);
                townLevelRegionList.add(townLevelRegion);
            }
            tTownLevelRegionMapper.batchInsertTTownLevelRegion(townLevelRegionList);
        }
        return json;
    }

    /**
     * 获取村级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getVillage(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("region/village/information","READ",map);
        log.info("获取村级行政区结果=========" + json.toString());
        //结果入库
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List< TVillageLevelRegion> villageLevelRegionList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TVillageLevelRegionVo tVillageLevelRegionVo = JSONObject.toJavaObject(data.getJSONObject(i), TVillageLevelRegionVo.class);
                TVillageLevelRegion villageLevelRegion = new TVillageLevelRegion();
                GovernmentDataCopyUtil.copyToLocalData(tVillageLevelRegionVo,villageLevelRegion);
                villageLevelRegionList.add(villageLevelRegion);
            }
            tVillageLevelRegionMapper.batchInsertTVillageLevelRegion(villageLevelRegionList);
        }
        return json;
    }


    /**
     * 获取行业专家档案
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getProfessorInfo(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("professor/application/information","READ",map);
        log.info("获取行业专家档案结果=========" + json.toString());
        //结果入库
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TProAppInforBrowse> proAppInforBrowseList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                ProAppInforBrowseVo proAppInforBrowseVo = JSONObject.toJavaObject(data.getJSONObject(i), ProAppInforBrowseVo.class);
                TProAppInforBrowse tProAppInforBrowse = new TProAppInforBrowse();
                GovernmentDataCopyUtil.copyToLocalData(proAppInforBrowseVo,tProAppInforBrowse);
                proAppInforBrowseList.add(tProAppInforBrowse);
            }
            if (proAppInforBrowseList.size() > 0) {
                tProAppInforBrowseMapper.batchInsertTProAppInforBrowse(proAppInforBrowseList);
            }
        }
        return json;
    }

    /**
     * 获取专家行为档案
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getBehaviour(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("professor/behaviour/information","READ",map);
        log.info("获取专家行为档案结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<FProBehInforBrowse> proBehInforBrowseList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                ProBehInfoBrowseVo proBehInfoBrowseVo = JSONObject.toJavaObject(data.getJSONObject(i), ProBehInfoBrowseVo.class);
                FProBehInforBrowse proBehInforBrowse = new FProBehInforBrowse();
                GovernmentDataCopyUtil.copyToLocalData(proBehInfoBrowseVo,proBehInforBrowse);
                proBehInforBrowseList.add(proBehInforBrowse);
            }
            if (proBehInforBrowseList.size() > 0) {
                fProBehInforBrowseMapper.batchInsertFProBehInforBrowse(proBehInforBrowseList);
            }
        }
        return json;
    }

    /**
     * 获取检查任务
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getTask(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/task/information","READ",map);
        log.info("获取检查任务结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsTaskInfor> taskInforList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsTaskInforVo tInsTaskInforVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsTaskInforVo.class);
                TInsTaskInfor tInsTaskInfor = new TInsTaskInfor();
                GovernmentDataCopyUtil.copyToLocalData(tInsTaskInforVo,tInsTaskInfor);
                taskInforList.add(tInsTaskInfor);
            }
            tInsTaskInforMapper.batchInsertTInsTaskInfo(taskInforList);
        }
        return json;
    }


    /**
     * 获取检查范围
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getScope(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/scope/information","READ",map);
        log.info("获取检查范围结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsScopeInfor> scopeInforList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsScopeInforVo insScopeInforVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsScopeInforVo.class);
                TInsScopeInfor tInsScopeInfor = new TInsScopeInfor();
                GovernmentDataCopyUtil.copyToLocalData(insScopeInforVo,tInsScopeInfor);
                scopeInforList.add(tInsScopeInfor);
            }
            tInsScopeInforMapper.batchInsertTInsScopeInfor(scopeInforList);
        }
        return json;
    }

    /**
     * 获取检查项
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getInspectList(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/inspect/list/information","READ",map);
        log.info("获取检查项结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsInsListInfor> insInsListInforList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsInsListInforVo insInsListInforVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsInsListInforVo.class);
                TInsInsListInfor tInsInsListInfor = new TInsInsListInfor();
                GovernmentDataCopyUtil.copyToLocalData(insInsListInforVo,tInsInsListInfor);
                insInsListInforList.add(tInsInsListInfor);
            }
            tInsInsListInforMapper.batchInsertTInsInsListInfor(insInsListInforList);
        }
        return json;
    }

    /**
     * 获取调查项
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject getSurveyList(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/survey/list/information","READ",map);
        log.info("获取调查项结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsSurListInfor> insSurListInforList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsSurListInforVo insSurListInforVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsSurListInforVo.class);
                TInsSurListInfor insSurListInfor = new TInsSurListInfor();
                GovernmentDataCopyUtil.copyToLocalData(insSurListInforVo,insSurListInfor);
                insSurListInforList.add(insSurListInfor);
            }
            insSurListInforMapper.batchInsertTInsSurListInfor(insSurListInforList);
        }
        return json;
    }

    /**
     * 获取抽查隐患
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    public JSONObject getSpotHazard(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/spot/hazard/reflection","READ",map);
        log.info("获取抽查隐患结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsSpotHazardRef> tInsSpotHazardRefList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsSpotHazardRefVo insSpotHazardRefVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsSpotHazardRefVo.class);
                TInsSpotHazardRef insSpotHazardRef = new TInsSpotHazardRef();
                GovernmentDataCopyUtil.copyToLocalData(insSpotHazardRefVo,insSpotHazardRef);
                tInsSpotHazardRefList.add(insSpotHazardRef);
            }
            tInsSpotHazardRefMapper.batchInsertTInsSpotHazardRef(tInsSpotHazardRefList);
        }
        return json;
    }


    /**
     * 获取隐患分类分级标准
     * @param map 入参
     * @return
     * @throws Exception
     */
    @Override
    public JSONObject getStandard(Map<String, Object> map) throws Exception {
        JSONObject json = governmentDataUtil.getInfo("inspection/standard/information","READ",map);
        log.info("获取隐患分类分级标准结果=========" + json.toString());
        if(null != json && "0".equals(json.getString("resultCode")) && null != json.getJSONArray("data")){
            JSONArray data = json.getJSONArray("data");
            List<TInsStaInfor> tInsStaInforList = new ArrayList<>();
            for(int i = 0; i < data.size(); i++){
                TInsStaInforVo insStaInforVo = JSONObject.toJavaObject(data.getJSONObject(i), TInsStaInforVo.class);
                TInsStaInfor insStaInfor = new TInsStaInfor();
                GovernmentDataCopyUtil.copyToLocalData(insStaInforVo,insStaInfor);
                tInsStaInforList.add(insStaInfor);
            }
            tInsStaInforMapper.batchInsertTInsStaInfor(tInsStaInforList);
        }
        return json;
    }


}
