package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TVillageLevelRegion;

/**
 * 村级行政区Service接口
 * 
 * @author zehong
 * @date 2024-06-07
 */
public interface ITVillageLevelRegionService 
{
    /**
     * 查询村级行政区
     * 
     * @param fId 村级行政区ID
     * @return 村级行政区
     */
    public TVillageLevelRegion selectTVillageLevelRegionById(Long fId);

    /**
     * 查询村级行政区列表
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 村级行政区集合
     */
    public List<TVillageLevelRegion> selectTVillageLevelRegionList(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 新增村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    public int insertTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 修改村级行政区
     * 
     * @param tVillageLevelRegion 村级行政区
     * @return 结果
     */
    public int updateTVillageLevelRegion(TVillageLevelRegion tVillageLevelRegion);

    /**
     * 批量删除村级行政区
     * 
     * @param fIds 需要删除的村级行政区ID
     * @return 结果
     */
    public int deleteTVillageLevelRegionByIds(Long[] fIds);

    /**
     * 删除村级行政区信息
     * 
     * @param fId 村级行政区ID
     * @return 结果
     */
    public int deleteTVillageLevelRegionById(Long fId);
}
