package com.zehong.system.service;

import com.zehong.system.domain.TVehicleInfo;

import java.util.List;

/**
 * 燃气车辆信息Service接口
 *
 * @author zehong
 * @date 2022-03-17
 */
public interface ITVehicleInfoService
{
    /**
     * 查询燃气车辆信息
     *
     * @param vehicleId 燃气车辆信息ID
     * @return 燃气车辆信息
     */
    public TVehicleInfo selectTVehicleInfoById(Long vehicleId);

    /**
     * 查询燃气车辆信息列表
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 燃气车辆信息集合
     */
    public List<TVehicleInfo> selectTVehicleInfoList(TVehicleInfo tVehicleInfo);

    /**
     * 新增燃气车辆信息
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 结果
     */
    public int insertTVehicleInfo(TVehicleInfo tVehicleInfo);

    /**
     * 修改燃气车辆信息
     *
     * @param tVehicleInfo 燃气车辆信息
     * @return 结果
     */
    public int updateTVehicleInfo(TVehicleInfo tVehicleInfo);

    /**
     * 批量删除燃气车辆信息
     *
     * @param vehicleIds 需要删除的燃气车辆信息ID
     * @return 结果
     */
    public int deleteTVehicleInfoByIds(Long[] vehicleIds);

    /**
     * 删除燃气车辆信息信息
     *
     * @param vehicleId 燃气车辆信息ID
     * @return 结果
     */
    public int deleteTVehicleInfoById(Long vehicleId);

    /**
     * 微信小程序  车辆详细信息查询接口
     * @param tVehicleInfo
     * @return
     */
    TVehicleInfo getTVehicleInfo(TVehicleInfo tVehicleInfo);
}
