package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSupMajorHazard;

/**
 * 重大危险源监管Service接口
 * 
 * @author zehong
 * @date 2024-04-19
 */
public interface ITSupMajorHazardService 
{
    /**
     * 查询重大危险源监管
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 重大危险源监管
     */
    public TSupMajorHazard selectTSupMajorHazardById(Long fHazardId);

    /**
     * 查询重大危险源监管列表
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管集合
     */
    public List<TSupMajorHazard> selectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard);

    /**
     * 导出重大危险源监管列表
     *
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管集合
     */
    public List<TSupMajorHazard> exportselectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard);

    /**
     * 新增重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    public int insertTSupMajorHazard(TSupMajorHazard tSupMajorHazard);

    /**
     * 修改重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    public int updateTSupMajorHazard(TSupMajorHazard tSupMajorHazard);

    /**
     * 批量删除重大危险源监管
     * 
     * @param fHazardIds 需要删除的重大危险源监管ID
     * @return 结果
     */
    public int deleteTSupMajorHazardByIds(Long[] fHazardIds);

    /**
     * 删除重大危险源监管信息
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 结果
     */
    public int deleteTSupMajorHazardById(Long fHazardId);
}
