package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPatrolWorkInfo;

/**
 * 巡检任务Service接口
 * 
 * @author zehong
 * @date 2023-08-05
 */
public interface ITPatrolWorkInfoService 
{
    /**
     * 查询巡检任务
     * 
     * @param workId 巡检任务ID
     * @return 巡检任务
     */
    public TPatrolWorkInfo selectTPatrolWorkInfoById(Long workId);

    /**
     * 查询巡检任务列表
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 巡检任务集合
     */
    public List<TPatrolWorkInfo> selectTPatrolWorkInfoList(TPatrolWorkInfo tPatrolWorkInfo);

    /**
     * 新增巡检任务
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 结果
     */
    public int insertTPatrolWorkInfo(TPatrolWorkInfo tPatrolWorkInfo);

    /**
     * 修改巡检任务
     * 
     * @param tPatrolWorkInfo 巡检任务
     * @return 结果
     */
    public int updateTPatrolWorkInfo(TPatrolWorkInfo tPatrolWorkInfo);

    /**
     * 批量删除巡检任务
     * 
     * @param workIds 需要删除的巡检任务ID
     * @return 结果
     */
    public int deleteTPatrolWorkInfoByIds(Long[] workIds);

    /**
     * 删除巡检任务信息
     * 
     * @param workId 巡检任务ID
     * @return 结果
     */
    public int deleteTPatrolWorkInfoById(Long workId);
}
