package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TMessageDetailInfo;

/**
 * 消息详情Service接口
 * 
 * @author zehong
 * @date 2023-09-14
 */
public interface ITMessageDetailInfoService 
{
    /**
     * 查询消息详情
     * 
     * @param messageDetailId 消息详情ID
     * @return 消息详情
     */
    public TMessageDetailInfo selectTMessageDetailInfoById(Long messageDetailId);

    /**
     * 查询消息详情列表
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 消息详情集合
     */
    public List<TMessageDetailInfo> selectTMessageDetailInfoList(TMessageDetailInfo tMessageDetailInfo);

    /**
     * 新增消息详情
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 结果
     */
    public int insertTMessageDetailInfo(TMessageDetailInfo tMessageDetailInfo);

    /**
     * 修改消息详情
     * 
     * @param tMessageDetailInfo 消息详情
     * @return 结果
     */
    public int updateTMessageDetailInfo(TMessageDetailInfo tMessageDetailInfo);

    /**
     * 批量删除消息详情
     * 
     * @param messageDetailIds 需要删除的消息详情ID
     * @return 结果
     */
    public int deleteTMessageDetailInfoByIds(Long[] messageDetailIds);

    /**
     * 删除消息详情信息
     * 
     * @param messageDetailId 消息详情ID
     * @return 结果
     */
    public int deleteTMessageDetailInfoById(Long messageDetailId);
}
