package com.zehong.system.service;

import java.util.HashMap;
import java.util.List;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.TLpgVehicleInfo;
import com.zehong.system.domain.vo.TLpgSafeCheckRecordImportVo;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油车辆信息Service接口
 * 
 * @author zehong
 * @date 2024-07-19
 */
public interface ITLpgVehicleInfoService 
{
    /**
     * 查询液化石油车辆信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 液化石油车辆信息
     */
    public TLpgVehicleInfo selectTLpgVehicleInfoById(Long vehicleId);

    /**
     * 查询液化石油车辆信息列表
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 液化石油车辆信息集合
     */
    public List<TLpgVehicleInfo> selectTLpgVehicleInfoList(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 查询这个企业下 车牌号是否重复
     * @param carNums c
     * @param enterpriseId e
     * @return r
     */
    public List<TLpgVehicleInfo> queryByCarNumsAndEnterpriseId(List<String> carNums,String enterpriseId);

    /**
     * 新增液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    public int insertTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 修改液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    public int updateTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(List<TLpgVehicleInfo> list);

    /**
     * 批量修改
     * @param list list
     * @return r
     */
    public int updateBatch(List<TLpgVehicleInfo> list);
    /**
     * 批量删除液化石油车辆信息
     * 
     * @param vehicleIds 需要删除的液化石油车辆信息ID
     * @return 结果
     */
    public int deleteTLpgVehicleInfoByIds(Long[] vehicleIds);

    /**
     * 删除液化石油车辆信息信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 结果
     */
    public int deleteTLpgVehicleInfoById(Long vehicleId);
    /**
     * 导入
     * @param XmbhList data
     * @param updateSupport 是否更新
     * @param response res
     * @return r
     */
    public AjaxResult importLpgSafeCheckRecordInfo(List<TLpgVehicleInfo> XmbhList, boolean updateSupport, HttpServletResponse response);
}
