package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInsHazRef;

/**
 * 监督检查-监督检查发现隐患及整改，执法结果Service接口
 * 
 * @author zehong
 * @date 2024-05-21
 */
public interface ITInsHazRefService 
{
    /**
     * 查询监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param fInsHazRefId 监督检查-监督检查发现隐患及整改，执法结果ID
     * @return 监督检查-监督检查发现隐患及整改，执法结果
     */
    public TInsHazRef selectTInsHazRefById(Long fInsHazRefId);

    /**
     * 查询监督检查-监督检查发现隐患及整改，执法结果列表
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 监督检查-监督检查发现隐患及整改，执法结果集合
     */
    public List<TInsHazRef> selectTInsHazRefList(TInsHazRef tInsHazRef);

    /**
     * 新增监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 结果
     */
    public int insertTInsHazRef(TInsHazRef tInsHazRef);

    /**
     * 修改监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param tInsHazRef 监督检查-监督检查发现隐患及整改，执法结果
     * @return 结果
     */
    public int updateTInsHazRef(TInsHazRef tInsHazRef);

    /**
     * 批量删除监督检查-监督检查发现隐患及整改，执法结果
     * 
     * @param fInsHazRefIds 需要删除的监督检查-监督检查发现隐患及整改，执法结果ID
     * @return 结果
     */
    public int deleteTInsHazRefByIds(Long[] fInsHazRefIds);

    /**
     * 删除监督检查-监督检查发现隐患及整改，执法结果信息
     * 
     * @param fInsHazRefId 监督检查-监督检查发现隐患及整改，执法结果ID
     * @return 结果
     */
    public int deleteTInsHazRefById(Long fInsHazRefId);

    /**
     * 上传监督检查发现隐患及整改、执法结果
     * @param fInsHazRefId 结果id
     * @return
     */
    int reportHazRefInfo(Long fInsHazRefId) throws Exception;

    /**
     * 根据检查记录上传隐患
     * @param checkCode
     * @return
     */
    int reportHazRefInfoByCheckCode(String checkCode) throws Exception;
}
