package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyDevice;

/**
 * 应急设备Service接口
 * 
 * @author zehong
 * @date 2022-03-17
 */
public interface ITEmergencyDeviceService 
{
    /**
     * 查询应急设备
     * 
     * @param id 应急设备ID
     * @return 应急设备
     */
    public TEmergencyDevice selectTEmergencyDeviceById(String id);

    /**
     * 查询应急设备列表
     * 
     * @param tEmergencyDevice 应急设备
     * @return 应急设备集合
     */
    public List<TEmergencyDevice> selectTEmergencyDeviceList(TEmergencyDevice tEmergencyDevice);

    /**
     * 新增应急设备
     * 
     * @param tEmergencyDevice 应急设备
     * @return 结果
     */
    public int insertTEmergencyDevice(TEmergencyDevice tEmergencyDevice);

    /**
     * 修改应急设备
     * 
     * @param tEmergencyDevice 应急设备
     * @return 结果
     */
    public int updateTEmergencyDevice(TEmergencyDevice tEmergencyDevice);

    /**
     * 批量删除应急设备
     * 
     * @param ids 需要删除的应急设备ID
     * @return 结果
     */
    public int deleteTEmergencyDeviceByIds(String[] ids);

    /**
     * 删除应急设备信息
     * 
     * @param id 应急设备ID
     * @return 结果
     */
    public int deleteTEmergencyDeviceById(String id);
}
