package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDetectorUserError;

/**
 * 燃气用户错误导入记录Service接口
 * 
 * @author zehong
 * @date 2024-08-30
 */
public interface ITDetectorUserErrorService 
{
    /**
     * 查询燃气用户错误导入记录
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 燃气用户错误导入记录
     */
    public TDetectorUserError selectTDetectorUserErrorById(Long userId);

    /**
     * 查询燃气用户错误导入记录列表
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 燃气用户错误导入记录集合
     */
    public List<TDetectorUserError> selectTDetectorUserErrorList(TDetectorUserError tDetectorUserError);

    /**
     * 新增燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    public int insertTDetectorUserError(TDetectorUserError tDetectorUserError);

    /**
     * 修改燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    public int updateTDetectorUserError(TDetectorUserError tDetectorUserError);

    /**
     * 批量删除燃气用户错误导入记录
     * 
     * @param userIds 需要删除的燃气用户错误导入记录ID
     * @return 结果
     */
    public int deleteTDetectorUserErrorByIds(Long[] userIds);

    /**
     * 删除燃气用户错误导入记录信息
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 结果
     */
    public int deleteTDetectorUserErrorById(Long userId);

    /**
     * 根据企业id统计错误数据
     * @return r
     */
    public int countByBeyondEnterpriseId();


    /**
     * 根据企业id 清除数据
     * @return r
     */
    public int clearImportErrorByEnterpriseId();
}
