package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TCityLevelRegion;

/**
 * 市级行政区Service接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface ITCityLevelRegionService 
{
    /**
     * 查询市级行政区
     * 
     * @param fId 市级行政区ID
     * @return 市级行政区
     */
    public TCityLevelRegion selectTCityLevelRegionById(Long fId);

    /**
     * 查询市级行政区列表
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 市级行政区集合
     */
    public List<TCityLevelRegion> selectTCityLevelRegionList(TCityLevelRegion tCityLevelRegion);

    /**
     * 新增市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    public int insertTCityLevelRegion(TCityLevelRegion tCityLevelRegion);

    /**
     * 修改市级行政区
     * 
     * @param tCityLevelRegion 市级行政区
     * @return 结果
     */
    public int updateTCityLevelRegion(TCityLevelRegion tCityLevelRegion);

    /**
     * 批量删除市级行政区
     * 
     * @param fIds 需要删除的市级行政区ID
     * @return 结果
     */
    public int deleteTCityLevelRegionByIds(Long[] fIds);

    /**
     * 删除市级行政区信息
     * 
     * @param fId 市级行政区ID
     * @return 结果
     */
    public int deleteTCityLevelRegionById(Long fId);
}
