package com.zehong.system.service;
import com.zehong.system.domain.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 管道信息数据实现层
 */
public interface IPipeInterfaceService {

    /**
     * 查询管道数据列表
     * @return
     */
    List<PipeDate> selectPipeData(String enterId);

    /**
     * 查询管道数据列表 名称不为空
     * @return
     */
    List<PipeDate> getPipeForSelect(String enterId);

    PipeDate getPipeBypipeId(String pipeId);

    /**
     * 获取分组数据
     * @return
     */
    List<PipeDate> selectGroupPipeData();

    /**
     * 调压箱数据查询方法
     * @return
     */
    List<DeviceData> selectDeviceData(String enterId);

    /**
     *查询下级设备数据
     * @param deviceId
     * @return
     */
    List<PressureFlow> selectPressureFlow(String deviceId);

    /**
     * 场站信息查询方法
     * @return
     */
    List<TSiteStationInfoData> selectTSiteStationInfoData(String enterId);

    /**
     * 查询场站下级设备数据
     * @param siteStationId
     * @return
     */
    List<PressureFlow> selecttSiteStationInfoDataList(String siteStationId);

    /**
     * 监控信息查询
     * @return
     */
    List<TvideoManagerData> selectTvideoManagerData();

    /**
     * 燃气用户信息查询接口
     * @return
     */
    List<TdetectorUserData> selectTdetectorUser();

    /**
     * 查询企业名称id方法
     * @return
     */
    List<TenterpriseInfoData> selectTenterpriseInfoData();

    /**
     * 查询阀门井数据
     * @return
     */
    List<DeviceData> selectvalveData(String enterId);

    /**
     * 查询下级在线设备数量
     * @param pressureList
     * @return
     */
    int selectOnlineQuantity(List<PressureFlow> pressureList,@Param("isOnLine") int isOnLine);

    /**
     * 查询历史报警数量
     * @param pressureList
     * @return
     */
    int selectHistoricalAlarm(List<PressureFlow> pressureList);

    /**
     * 查询已处理报警
     * @param pressureList
     * @return
     */
    int selectProcessAlarm(List<PressureFlow> pressureList);

    /**
     * 查询报警中
     * @param pressureList
     * @return
     */
    int selectInAlarm(List<PressureFlow> pressureList);

    /**
     * 查询 场站/设备 列表信息方法
     * @param devId
     * @param relationDeviceType
     * @return
     */
    List<TAssociatedEquipment> selectSensingDevice(String devId, String relationDeviceType);

    /**
     * 查询上级设备是否有下级设备
     * @param deviceId
     * @return
     */
    int selectValveWellIsNUll(String deviceId,int type);

    /**
     * 查询下级全部数据方法
     * @param type
     * @return
     */
    List<PressureFlow> selectPressureFlows(String type);
}
