package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;

/**
 * 液化石油气监管-液化气用户-安全装置加装维护Mapper接口
 * 
 * @author zehong
 * @date 2024-09-09
 */
public interface TYehuaqiuserSafetyDeviceInfoMapper 
{
    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 液化石油气监管-液化气用户-安全装置加装维护
     */
    public TYehuaqiuserSafetyDeviceInfo selectTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId);

    /**
     * 根据userid查询数据
     * @param userId u
     * @return r
     */
    public List<TYehuaqiuserSafetyDeviceInfo> queryDeviceInfoByUserId(Long userId);

    /**
     * 查询液化石油气监管-液化气用户-安全装置加装维护列表
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 液化石油气监管-液化气用户-安全装置加装维护集合
     */
    public List<TYehuaqiuserSafetyDeviceInfo> selectTYehuaqiuserSafetyDeviceInfoList(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 新增液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    public int insertTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 批量插入
     * @param tYehuaqiuserSafetyDeviceInfos t
     * @return r
     */
    public int insertBatch(@Param("list") List<TYehuaqiuserSafetyDeviceInfo> tYehuaqiuserSafetyDeviceInfos);

    /**
     * 批量删除
     * @param list list
     * @return r
     */
    public int deleteBatchSafetyDeviceByUserIds(@Param("list") List<Long> list);

    /**
     * 根据 userid删除 数据
     * @param userId user
     * @return r
     */
    public void deleteYehuaqiuserSafetyDeviceInfoUserId(Long userId);

    /**
     * 修改液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param tYehuaqiuserSafetyDeviceInfo 液化石油气监管-液化气用户-安全装置加装维护
     * @return 结果
     */
    public int updateTYehuaqiuserSafetyDeviceInfo(TYehuaqiuserSafetyDeviceInfo tYehuaqiuserSafetyDeviceInfo);

    /**
     * 删除液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceId 液化石油气监管-液化气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTYehuaqiuserSafetyDeviceInfoById(Long fSafetyDeviceId);

    /**
     * 批量删除液化石油气监管-液化气用户-安全装置加装维护
     * 
     * @param fSafetyDeviceIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTYehuaqiuserSafetyDeviceInfoByIds(Long[] fSafetyDeviceIds);
}
