package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TWorkTaskInspect;

/**
 * 入户安检Mapper接口
 * 
 * @author zehong
 * @date 2023-09-15
 */
public interface TWorkTaskInspectMapper 
{
    /**
     * 查询入户安检
     * 
     * @param inspectId 入户安检ID
     * @return 入户安检
     */
    public TWorkTaskInspect selectTWorkTaskInspectById(Long inspectId);

    /**
     * 查询入户安检列表
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 入户安检集合
     */
    public List<TWorkTaskInspect> selectTWorkTaskInspectList(TWorkTaskInspect tWorkTaskInspect);
    public List<TWorkTaskInspect> selectTWorkTaskInspectwxList(TWorkTaskInspect tWorkTaskInspect);
    public List<TDetectorUser> selectTWorkTaskInspectwxnotList(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 结束过期任务
     */
    public Integer updateOld();

    /**
     * 新增入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    public int insertTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 修改入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    public int updateTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 删除入户安检
     * 
     * @param inspectId 入户安检ID
     * @return 结果
     */
    public int deleteTWorkTaskInspectById(Long inspectId);

    /**
     * 批量删除入户安检
     * 
     * @param inspectIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTWorkTaskInspectByIds(Long[] inspectIds);

    /**
     * 入户安检统计
     * @param tWorkTaskInspect 入户安检实体
     * @return
     */
    List<Map<String,Object>> inspectStatistic(TWorkTaskInspect tWorkTaskInspect);

    /**
     * 查询任务已安检用户
     * @param taskId 任务主键
     * @return
     */
    List<Long> getHasInspectByTaskId(Long taskId);
}
