package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TUserManageVillage;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;

/**
 * 基本信息维护-用户管理-居住区(村庄)Mapper接口
 * 
 * @author zehong
 * @date 2024-08-27
 */
public interface TUserManageVillageMapper 
{
    /**
     * 查询基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 基本信息维护-用户管理-居住区(村庄)
     */
    public TUserManageVillage selectTUserManageVillageById(Long fVillageId);

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 基本信息维护-用户管理-居住区(村庄)集合
     */
    public List<TUserManageVillage> selectTUserManageVillageList(TUserManageVillage tUserManageVillage);

    /**
     * 提供给第三方使用的查询接口
     * @return r
     */
    public List<TUserManageVillage> queryUserManageVillageForThirdParty();

    /**
     * 导出用
     * @param tUserManageVillage tUserManageVillage
     * @return list
     */
    public List<TUserManageVillage> exportUserManageVillageList(TUserManageVillage tUserManageVillage);

    /**
     * 根据 村名称集合 查询 村列表
     * @param list v
     * @return r
     */
    List<TUserManageVillage> queryByVillageNames(@Param("list") List<String> list);

    /**
     * 根据id集合查询
     * @param villageIds s
     * @return r
     */
    List<TUserManageVillage> queryByVillageIds(@Param("list")  List<Long> villageIds);
    /**
     * 新增基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    public int insertTUserManageVillage(TUserManageVillage tUserManageVillage);

    /**
     * 批量插入
     * @param userManageVillages s
     * @return s
     */
    int insertBatch(List<TUserManageVillage> userManageVillages);
    /**
     * 修改基本信息维护-用户管理-居住区(村庄)
     * 
     * @param tUserManageVillage 基本信息维护-用户管理-居住区(村庄)
     * @return 结果
     */
    public int updateTUserManageVillage(TUserManageVillage tUserManageVillage);

    /**
     * 删除基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageId 基本信息维护-用户管理-居住区(村庄)ID
     * @return 结果
     */
    public int deleteTUserManageVillageById(Long fVillageId);

    /**
     * 批量删除基本信息维护-用户管理-居住区(村庄)
     * 
     * @param fVillageIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTUserManageVillageByIds(Long[] fVillageIds);
}
