package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSupBalStopSup;

/**
 * 供需平衡-停气监管Mapper接口
 * 
 * @author zehong
 * @date 2024-06-21
 */
public interface TSupBalStopSupMapper 
{
    /**
     * 查询供需平衡-停气监管
     * 
     * @param fGasStopId 供需平衡-停气监管ID
     * @return 供需平衡-停气监管
     */
    public TSupBalStopSup selectTSupBalStopSupById(Long fGasStopId);

    /**
     * 查询供需平衡-停气监管列表
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 供需平衡-停气监管集合
     */
    public List<TSupBalStopSup> selectTSupBalStopSupList(TSupBalStopSup tSupBalStopSup);

    /**
     * 新增供需平衡-停气监管
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 结果
     */
    public int insertTSupBalStopSup(TSupBalStopSup tSupBalStopSup);

    /**
     * 修改供需平衡-停气监管
     * 
     * @param tSupBalStopSup 供需平衡-停气监管
     * @return 结果
     */
    public int updateTSupBalStopSup(TSupBalStopSup tSupBalStopSup);

    /**
     * 删除供需平衡-停气监管
     * 
     * @param fGasStopId 供需平衡-停气监管ID
     * @return 结果
     */
    public int deleteTSupBalStopSupById(Long fGasStopId);

    /**
     * 批量删除供需平衡-停气监管
     * 
     * @param fGasStopIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSupBalStopSupByIds(Long[] fGasStopIds);
}
