package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSpecialUser;

/**
 * 特殊用户管控Mapper接口
 * 
 * @author zehong
 * @date 2026-02-02
 */
public interface TSpecialUserMapper 
{
    /**
     * 查询特殊用户管控
     * 
     * @param specialId 特殊用户管控ID
     * @return 特殊用户管控
     */
    public TSpecialUser selectTSpecialUserById(Long specialId);

    /**
     * 查询特殊用户管控列表
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 特殊用户管控集合
     */
    public List<TSpecialUser> selectTSpecialUserList(TSpecialUser tSpecialUser);

    /**
     * 新增特殊用户管控
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 结果
     */
    public int insertTSpecialUser(TSpecialUser tSpecialUser);

    /**
     * 批量新增
     * @param list
     * @return
     */
    public int inserts(List<TSpecialUser> list);

    /**
     * 修改特殊用户管控
     * 
     * @param tSpecialUser 特殊用户管控
     * @return 结果
     */
    public int updateTSpecialUser(TSpecialUser tSpecialUser);

    /**
     * 删除特殊用户管控
     * 
     * @param specialId 特殊用户管控ID
     * @return 结果
     */
    public int deleteTSpecialUserById(Long specialId);

    /**
     * 批量删除特殊用户管控
     * 
     * @param specialIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSpecialUserByIds(Long[] specialIds);
}
