package com.zehong.system.mapper;

import com.zehong.system.domain.TPractitionerInfo;

import java.util.List;

/**
 * 从业人员信息Mapper接口
 *
 * @author zehong
 * @date 2023-08-16
 */
public interface TPractitionerInfoMapper
{
    /**
     * 查询从业人员信息
     *
     * @param practitionerId 从业人员信息ID
     * @return 从业人员信息
     */
    public TPractitionerInfo selectTPractitionerInfoById(Long practitionerId);

    /**
     * 查询从业人员信息列表
     *
     * @param tPractitionerInfo 从业人员信息
     * @return 从业人员信息集合
     */
    public List<TPractitionerInfo> selectTPractitionerInfoList(TPractitionerInfo tPractitionerInfo);

    /**
     * 新增从业人员信息
     *
     * @param tPractitionerInfo 从业人员信息
     * @return 结果
     */
    public int insertTPractitionerInfo(TPractitionerInfo tPractitionerInfo);

    /**
     * 修改从业人员信息
     *
     * @param tPractitionerInfo 从业人员信息
     * @return 结果
     */
    public int updateTPractitionerInfo(TPractitionerInfo tPractitionerInfo);

    /**
     * 删除从业人员信息
     *
     * @param practitionerId 从业人员信息ID
     * @return 结果
     */
    public int deleteTPractitionerInfoById(Long practitionerId);

    /**
     * 批量删除从业人员信息
     *
     * @param practitionerIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPractitionerInfoByIds(Long[] practitionerIds);

    /**
     * 查询登录信息
     * @param tPractitionerInfo
     * @return
     */
    List<TPractitionerInfo> loginTPractitioner(TPractitionerInfo tPractitionerInfo);
}
