package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;
import com.zehong.system.domain.TPipeOldPlanProcess;
import org.apache.ibatis.annotations.Param;

/**
 * 老旧管网-改造计划和进度Mapper接口
 * 
 * @author zehong
 * @date 2024-06-15
 */
public interface TPipeOldPlanProcessMapper 
{
    /**
     * 查询老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 老旧管网-改造计划和进度
     */
    public TPipeOldPlanProcess selectTPipeOldPlanProcessById(Long fOldPlanProcessId);

    /**
     * 查询老旧管网-改造计划和进度列表
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 老旧管网-改造计划和进度集合
     */
    public List<TPipeOldPlanProcess> selectTPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 查询老旧管网-改造计划和进度列表-导出用
     *
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 老旧管网-改造计划和进度集合
     */
    public List<TPipeOldPlanProcess> exportPipeOldPlanProcessList(TPipeOldPlanProcess tPipeOldPlanProcess);


    /**
     * 新增老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    public int insertTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 修改老旧管网-改造计划和进度
     * 
     * @param tPipeOldPlanProcess 老旧管网-改造计划和进度
     * @return 结果
     */
    public int updateTPipeOldPlanProcess(TPipeOldPlanProcess tPipeOldPlanProcess);

    /**
     * 企业端上传数据
     * @return
     */
    public int entReportPipeOldPlanProcess(@Param("state")  String state, @Param("entUploadTime") String entUploadTime,
                                           @Param("fOldPlanProcessId") Long fOldPlanProcessId);

    /**
     * 删除老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessId 老旧管网-改造计划和进度ID
     * @return 结果
     */
    public int deleteTPipeOldPlanProcessById(Long fOldPlanProcessId);

    /**
     * 批量删除老旧管网-改造计划和进度
     * 
     * @param fOldPlanProcessIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeOldPlanProcessByIds(Long[] fOldPlanProcessIds);
}
