package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsTaskInfor;
import org.apache.ibatis.annotations.Param;

/**
 * 监督检查-检查任务Mapper接口
 * 
 * @author zehong
 * @date 2024-05-16
 */
public interface TInsTaskInforMapper 
{
    /**
     * 查询监督检查-检查任务
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 监督检查-检查任务
     */
    public TInsTaskInfor selectTInsTaskInforById(Long fInsTaskInforId);

    /**
     * 查询监督检查-检查任务列表
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 监督检查-检查任务集合
     */
    public List<TInsTaskInfor> selectTInsTaskInforList(TInsTaskInfor tInsTaskInfor);

    /**
     * 新增监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    public int insertTInsTaskInfor(TInsTaskInfor tInsTaskInfor);

    /**
     * 修改监督检查-检查任务
     * 
     * @param tInsTaskInfor 监督检查-检查任务
     * @return 结果
     */
    public int updateTInsTaskInfor(TInsTaskInfor tInsTaskInfor);

    /**
     * 删除监督检查-检查任务
     * 
     * @param fInsTaskInforId 监督检查-检查任务ID
     * @return 结果
     */
    public int deleteTInsTaskInforById(Long fInsTaskInforId);

    /**
     * 批量删除监督检查-检查任务
     * 
     * @param fInsTaskInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsTaskInforByIds(Long[] fInsTaskInforIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsTaskInfo(List<TInsTaskInfor> list);
}
