package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsSurListInfor;

/**
 * 监督检查-调查项Mapper接口
 * 
 * @author zehong
 * @date 2024-05-18
 */
public interface TInsSurListInforMapper 
{
    /**
     * 查询监督检查-调查项
     * 
     * @param fInsSurListInforId 监督检查-调查项ID
     * @return 监督检查-调查项
     */
    public TInsSurListInfor selectTInsSurListInforById(Long fInsSurListInforId);

    /**
     * 查询监督检查-调查项列表
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 监督检查-调查项集合
     */
    public List<TInsSurListInfor> selectTInsSurListInforList(TInsSurListInfor tInsSurListInfor);

    /**
     * 新增监督检查-调查项
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 结果
     */
    public int insertTInsSurListInfor(TInsSurListInfor tInsSurListInfor);

    /**
     * 修改监督检查-调查项
     * 
     * @param tInsSurListInfor 监督检查-调查项
     * @return 结果
     */
    public int updateTInsSurListInfor(TInsSurListInfor tInsSurListInfor);

    /**
     * 删除监督检查-调查项
     * 
     * @param fInsSurListInforId 监督检查-调查项ID
     * @return 结果
     */
    public int deleteTInsSurListInforById(Long fInsSurListInforId);

    /**
     * 批量删除监督检查-调查项
     * 
     * @param fInsSurListInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsSurListInforByIds(Long[] fInsSurListInforIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsSurListInfor(List<TInsSurListInfor> list);
}
