package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsStaInfor;

/**
 * 监督检查-隐患分类分级标准Mapper接口
 * 
 * @author zehong
 * @date 2024-05-17
 */
public interface TInsStaInforMapper 
{
    /**
     * 查询监督检查-隐患分类分级标准
     * 
     * @param fInsStaInforId 监督检查-隐患分类分级标准ID
     * @return 监督检查-隐患分类分级标准
     */
    public TInsStaInfor selectTInsStaInforById(Long fInsStaInforId);

    /**
     * 查询监督检查-隐患分类分级标准列表
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 监督检查-隐患分类分级标准集合
     */
    public List<TInsStaInfor> selectTInsStaInforList(TInsStaInfor tInsStaInfor);

    /**
     * 新增监督检查-隐患分类分级标准
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 结果
     */
    public int insertTInsStaInfor(TInsStaInfor tInsStaInfor);

    /**
     * 修改监督检查-隐患分类分级标准
     * 
     * @param tInsStaInfor 监督检查-隐患分类分级标准
     * @return 结果
     */
    public int updateTInsStaInfor(TInsStaInfor tInsStaInfor);

    /**
     * 删除监督检查-隐患分类分级标准
     * 
     * @param fInsStaInforId 监督检查-隐患分类分级标准ID
     * @return 结果
     */
    public int deleteTInsStaInforById(Long fInsStaInforId);

    /**
     * 批量删除监督检查-隐患分类分级标准
     * 
     * @param fInsStaInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsStaInforByIds(Long[] fInsStaInforIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsStaInfor(List<TInsStaInfor> list);
}
