package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsRecInfor;

/**
 * 监督检查-检查记录Mapper接口
 * 
 * @author zehong
 * @date 2024-05-20
 */
public interface TInsRecInforMapper 
{
    /**
     * 查询监督检查-检查记录
     * 
     * @param fInsRecInforId 监督检查-检查记录ID
     * @return 监督检查-检查记录
     */
    public TInsRecInfor selectTInsRecInforById(Long fInsRecInforId);

    /**
     * 查询监督检查-检查记录列表
     * 
     * @param tInsRecInfor 监督检查-检查记录
     * @return 监督检查-检查记录集合
     */
    public List<TInsRecInfor> selectTInsRecInforList(TInsRecInfor tInsRecInfor);

    /**
     * 新增监督检查-检查记录
     * 
     * @param tInsRecInfor 监督检查-检查记录
     * @return 结果
     */
    public int insertTInsRecInfor(TInsRecInfor tInsRecInfor);

    /**
     * 修改监督检查-检查记录
     * 
     * @param tInsRecInfor 监督检查-检查记录
     * @return 结果
     */
    public int updateTInsRecInfor(TInsRecInfor tInsRecInfor);

    /**
     * 删除监督检查-检查记录
     * 
     * @param fInsRecInforId 监督检查-检查记录ID
     * @return 结果
     */
    public int deleteTInsRecInforById(Long fInsRecInforId);

    /**
     * 批量删除监督检查-检查记录
     * 
     * @param fInsRecInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsRecInforByIds(Long[] fInsRecInforIds);
}
