package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.THiddenTroubleInfo;

/**
 * 燃气隐患Mapper接口
 *
 * @author zehong
 * @date 2022-03-24
 */
public interface THiddenTroubleInfoMapper
{
    /**
     * 查询燃气隐患
     *
     * @param hiddenTroubleId 燃气隐患ID
     * @return 燃气隐患
     */
    public THiddenTroubleInfo selectTHiddenTroubleInfoById(Long hiddenTroubleId);

    /**
     * 查询燃气隐患列表
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 燃气隐患集合
     */
    public List<THiddenTroubleInfo> selectTHiddenTroubleInfoList(THiddenTroubleInfo tHiddenTroubleInfo);
    public List<Map<String,Object>> selectTHiddenTroubleInfoListCount(THiddenTroubleInfo tHiddenTroubleInfo);

    /**
     * 新增燃气隐患
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 结果
     */
    public int insertTHiddenTroubleInfo(THiddenTroubleInfo tHiddenTroubleInfo);

    /**
     * 修改燃气隐患
     *
     * @param tHiddenTroubleInfo 燃气隐患
     * @return 结果
     */
    public int updateTHiddenTroubleInfo(THiddenTroubleInfo tHiddenTroubleInfo);

    /**
     * 删除燃气隐患
     *
     * @param hiddenTroubleId 燃气隐患ID
     * @return 结果
     */
    public int deleteTHiddenTroubleInfoById(Long hiddenTroubleId);

    /**
     * 批量删除燃气隐患
     *
     * @param hiddenTroubleIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTHiddenTroubleInfoByIds(Long[] hiddenTroubleIds);

    /**
     * Excel数据导出查询接口
     * @param tHiddenTroubleInfo
     * @return
     */
    List<THiddenTroubleInfo> selectTHiddenTroubleInfoExcelList(THiddenTroubleInfo tHiddenTroubleInfo);

    /**
     * 查询燃气信息是否有修改
     * @param tHiddenTroubleInfo
     * @return
     */
    THiddenTroubleInfo selectDetails(THiddenTroubleInfo tHiddenTroubleInfo);
}
