package com.zehong.system.mapper;

import com.zehong.system.domain.TGasBottleTrackRecord;

import java.util.List;

/**
 * 气瓶追溯Mapper接口
 * 
 * @author zehong
 * @date 2023-08-18
 */
public interface TGasBottleTrackRecordMapper 
{
    /**
     * 查询气瓶追溯
     * 
     * @param trackRecordId 气瓶追溯ID
     * @return 气瓶追溯
     */
    public TGasBottleTrackRecord selectTGasBottleTrackRecordById(Long trackRecordId);

    /**
     * 查询气瓶追溯列表
     * 
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 气瓶追溯集合
     */
    public List<TGasBottleTrackRecord> selectTGasBottleTrackRecordList(TGasBottleTrackRecord tGasBottleTrackRecord);

    /**
     * 新增气瓶追溯
     * 
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 结果
     */
    public int insertTGasBottleTrackRecord(TGasBottleTrackRecord tGasBottleTrackRecord);

    /**
     * 修改气瓶追溯
     * 
     * @param tGasBottleTrackRecord 气瓶追溯
     * @return 结果
     */
    public int updateTGasBottleTrackRecord(TGasBottleTrackRecord tGasBottleTrackRecord);

    /**
     * 删除气瓶追溯
     * 
     * @param trackRecordId 气瓶追溯ID
     * @return 结果
     */
    public int deleteTGasBottleTrackRecordById(Long trackRecordId);

    /**
     * 批量删除气瓶追溯
     * 
     * @param trackRecordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTGasBottleTrackRecordByIds(Long[] trackRecordIds);
}
