package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEmployedPeopleInfoError;
import org.apache.ibatis.annotations.Param;

/**
 * 从业人员错误导入记录Mapper接口
 * 
 * @author zehong
 * @date 2024-06-01
 */
public interface TEmployedPeopleInfoErrorMapper 
{
    /**
     * 查询从业人员错误导入记录
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 从业人员错误导入记录
     */
    public TEmployedPeopleInfoError selectTEmployedPeopleInfoErrorById(Long employedPeopleErrorId);

    /**
     * 查询从业人员错误导入记录列表
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 从业人员错误导入记录集合
     */
    public List<TEmployedPeopleInfoError> selectTEmployedPeopleInfoErrorList(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 新增从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    public int insertTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 批量新增从业人员错误导入记录
     *
     * @param tEmployedPeopleInfoErrors 从业人员错误导入记录
     * @return 结果
     */
    public int batchInsertTEmployedPeopleInfoError(@Param(value = "tEmployedPeopleInfoErrors") List<TEmployedPeopleInfoError> tEmployedPeopleInfoErrors);

    /**
     * 修改从业人员错误导入记录
     * 
     * @param tEmployedPeopleInfoError 从业人员错误导入记录
     * @return 结果
     */
    public int updateTEmployedPeopleInfoError(TEmployedPeopleInfoError tEmployedPeopleInfoError);

    /**
     * 删除从业人员错误导入记录
     * 
     * @param employedPeopleErrorId 从业人员错误导入记录ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoErrorById(Long employedPeopleErrorId);

    /**
     * 批量删除从业人员错误导入记录
     * 
     * @param employedPeopleErrorIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEmployedPeopleInfoErrorByIds(Long[] employedPeopleErrorIds);

    public int countByCreateByInt(String createBy);

    public int clearImportError(String createBy);
}
