package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceUser;
import org.apache.ibatis.annotations.Param;

/**
 * 设备用户Mapper接口
 * 
 * @author zehong
 * @date 2023-07-23
 */
public interface TDeviceUserMapper 
{
    /**
     * 查询设备用户
     * 
     * @param userId 设备用户ID
     * @return 设备用户
     */
    public TDeviceUser selectTDeviceUserById(Long userId);
    public TDeviceUser selectTDeviceUserByCode(@Param("code") String code);

    /**
     * 查询设备用户列表
     * 
     * @param tDeviceUser 设备用户
     * @return 设备用户集合
     */
    public List<TDeviceUser> selectTDeviceUserList(TDeviceUser tDeviceUser);
    public List<TDeviceUser> allListbyTownship();

    /**
     * 新增设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    public int insertTDeviceUser(TDeviceUser tDeviceUser);

    /**
     * 修改设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    public int updateTDeviceUser(TDeviceUser tDeviceUser);

    /**
     * 删除设备用户
     * 
     * @param userId 设备用户ID
     * @return 结果
     */
    public int deleteTDeviceUserById(Long userId);

    /**
     * 批量删除设备用户
     * 
     * @param userIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceUserByIds(Long[] userIds);
}
