package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;
import com.zehong.system.domain.TConGasProInfor;
import org.apache.ibatis.annotations.Param;

/**
 * 第三方施工-涉气第三方施工项目档案Mapper接口
 * 
 * @author zehong
 * @date 2024-06-26
 */
public interface TConGasProInforMapper 
{
    /**
     * 查询第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 第三方施工-涉气第三方施工项目档案
     */
    public TConGasProInfor selectTConGasProInforById(Long fConGasProInforId);

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案集合
     */
    public List<TConGasProInfor> selectTConGasProInforList(TConGasProInfor tConGasProInfor);

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表-导出用
     *
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 第三方施工-涉气第三方施工项目档案集合
     */
    public List<TConGasProInfor> exportTConGasProInforList(TConGasProInfor tConGasProInfor);

    /**
     * 新增第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    public int insertTConGasProInfor(TConGasProInfor tConGasProInfor);

    /**
     * 修改第三方施工-涉气第三方施工项目档案
     * 
     * @param tConGasProInfor 第三方施工-涉气第三方施工项目档案
     * @return 结果
     */
    public int updateTConGasProInfor(TConGasProInfor tConGasProInfor);

    /**
     *
     * 根据id修改 企业端上传状态*/
    public int updateEntUploadStateById( @Param("state")  String state,@Param("entUploadTime")   Date entUploadTime,
                                         @Param("fConGasProInforId") Long fConGasProInforId);

    /**
     * 删除第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforId 第三方施工-涉气第三方施工项目档案ID
     * @return 结果
     */
    public int deleteTConGasProInforById(Long fConGasProInforId);

    /**
     * 批量删除第三方施工-涉气第三方施工项目档案
     * 
     * @param fConGasProInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTConGasProInforByIds(Long[] fConGasProInforIds);
}
