package com.zehong.system.domain.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 探测器用户对象 t_detector_user
 * 
 * @author zehong
 * @date 2021-11-02
 */
@Data
public class TYehuaqiUserVO
{
    private static final long serialVersionUID = 1L;

    /** 用户id */
    private Long userId;

    /** 图标类型 */
    private String iconType;

    /** 用户状态（1正常，2报警） */
    private String userStatus;

    /** 用户名称 */
    private String nickName;

    /** 用户类型（1居民用户，2商业用户，3工业用户） */
    private String userType;

    private List<Object> detectorCountList;

    /** 设备类型 */
    private String detectorType;

    /** 探测器总数 */
    private Integer detectorCount;

    /** 在线数量 */
    private Integer onLineNum;

    /** 离线数量 */
    private Integer offLineNum;

    /** 历史报警数 */
    private Integer historyAlarmNum;

    /** 已处理报警 */
    private Integer cancelAlarmNum;

    /** 报警中 */
    private Integer processingAlarmNum;

    /** 地址 */
    private String address;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 联系人 */
    private String linkman;

    /** 电话 */
    private String phone;

    /** 邮箱 */
    private String email;
}
