package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气培训人员对象 t_train_person
 * 
 * @author zehong
 * @date 2023-04-22
 */
public class TTrainPerson extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 培训人员主键 */
    private Long id;

    /** 培训管理外键 */
    @Excel(name = "培训管理外键")
    private Long trainManageId;

    /** 培训人员id */
    @Excel(name = "培训人员id")
    private Long trainPersonId;

    /** 实际培训时长/秒 */
    @Excel(name = "实际培训时长/秒")
    private Integer realityTrainDuration;

    /** 是否完成培训：0未完成 1完成 */
    @Excel(name = "是否完成培训：0未完成 1完成")
    private String isFinish;

    /** 删除标志（0正常，1删除） */
    @Excel(name = "删除标志", readConverterExp = "0=正常，1删除")
    private String isDel;

    private String trainPersonName;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTrainManageId(Long trainManageId) 
    {
        this.trainManageId = trainManageId;
    }

    public Long getTrainManageId() 
    {
        return trainManageId;
    }
    public void setTrainPersonId(Long trainPersonId) 
    {
        this.trainPersonId = trainPersonId;
    }

    public Long getTrainPersonId() 
    {
        return trainPersonId;
    }
    public void setRealityTrainDuration(Integer realityTrainDuration) 
    {
        this.realityTrainDuration = realityTrainDuration;
    }

    public Integer getRealityTrainDuration() 
    {
        return realityTrainDuration;
    }
    public void setIsFinish(String isFinish) 
    {
        this.isFinish = isFinish;
    }

    public String getIsFinish() 
    {
        return isFinish;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getTrainPersonName() {
        return trainPersonName;
    }

    public void setTrainPersonName(String trainPersonName) {
        this.trainPersonName = trainPersonName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("trainManageId", getTrainManageId())
            .append("trainPersonId", getTrainPersonId())
            .append("realityTrainDuration", getRealityTrainDuration())
            .append("isFinish", getIsFinish())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("isDel", getIsDel())
            .toString();
    }
}
